/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.validation.ValidationResult;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;

@Interceptor
public class ValidationResultEnrichingInterceptor {
    public static final String REQUEST_VALIDATION_RESULT = ValidationResultEnrichingInterceptor.class.getName() + "_REQUEST_VALIDATION_RESULT";

    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public boolean addValidationResultsToOperationOutcome(RequestDetails theRequestDetails, IBaseResource theResponseObject) {
        if (theResponseObject instanceof IBaseOperationOutcome) {
            List validationResult;
            IBaseOperationOutcome oo = (IBaseOperationOutcome)theResponseObject;
            if (theRequestDetails != null && (validationResult = (List)theRequestDetails.getUserData().remove(REQUEST_VALIDATION_RESULT)) != null) {
                for (ValidationResult next : validationResult) {
                    next.populateOperationOutcome(oo);
                }
            }
        }
        return true;
    }

    public static void addValidationResultToRequestDetails(@Nullable RequestDetails theRequestDetails, @Nonnull ValidationResult theValidationResult) {
        if (theRequestDetails != null) {
            List results = (List)theRequestDetails.getUserData().computeIfAbsent(REQUEST_VALIDATION_RESULT, t -> new ArrayList(2));
            results.add(theValidationResult);
        }
    }
}

