/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.binder.CollectionBinder;
import ca.uhn.fhir.rest.server.ElementsSupportEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class ElementsParameter
implements IParameter {
    private Class<? extends Collection> myInnerCollectionType;

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding theMethodBinding) throws InternalErrorException, InvalidRequestException {
        Set<String> value = ElementsParameter.getElementsValueOrNull(theRequest, false);
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (this.myInnerCollectionType == null) {
            return StringUtils.join(value, (char)',');
        }
        try {
            Collection retVal = this.myInnerCollectionType.newInstance();
            retVal.addAll(value);
            return retVal;
        }
        catch (InstantiationException e) {
            throw new InternalErrorException(Msg.code((int)413) + "Failed to instantiate " + String.valueOf(this.myInnerCollectionType), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InternalErrorException(Msg.code((int)414) + "Failed to instantiate " + String.valueOf(this.myInnerCollectionType), (Throwable)e);
        }
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null) {
            throw new ConfigurationException(Msg.code((int)415) + "Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is of type " + String.valueOf(SummaryEnum.class) + " but can not be a collection of collections");
        }
        if (theInnerCollectionType != null) {
            this.myInnerCollectionType = CollectionBinder.getInstantiableCollectionType(theInnerCollectionType, (String)SummaryEnum.class.getSimpleName());
        }
    }

    public static Set<String> getElementsValueOrNull(RequestDetails theRequest, boolean theExclude) {
        String[] elementsValues;
        boolean standardMode;
        boolean bl = standardMode = theRequest.getServer().getElementsSupport() != ElementsSupportEnum.EXTENDED;
        if (theExclude && standardMode) {
            return null;
        }
        String paramName = "_elements";
        if (theExclude) {
            paramName = "_elements:exclude";
        }
        if ((elementsValues = theRequest.getParameters().get(paramName)) != null && elementsValues.length > 0) {
            HashSet<String> retVal = new HashSet<String>();
            for (String next : elementsValues) {
                StringTokenizer tok = new StringTokenizer(next, ",");
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (!StringUtils.isNotBlank((CharSequence)token) || token.contains(".") && standardMode) continue;
                    retVal.add(token);
                }
            }
            if (retVal.isEmpty()) {
                return null;
            }
            return retVal;
        }
        return null;
    }
}

