/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.messaging.json;

import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.server.messaging.json.HapiMessageHeaders;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public abstract class BaseJsonMessage<T>
implements Message<T>,
IModelJson {
    @JsonProperty(value="headers")
    private HapiMessageHeaders myHeaders;

    public BaseJsonMessage() {
        this.setDefaultRetryHeaders();
    }

    protected void setDefaultRetryHeaders() {
        HapiMessageHeaders messageHeaders = new HapiMessageHeaders();
        this.setHeaders(messageHeaders);
    }

    @Nonnull
    public MessageHeaders getHeaders() {
        return this.myHeaders.toMessageHeaders();
    }

    public HapiMessageHeaders getHapiHeaders() {
        if (Objects.isNull(this.myHeaders)) {
            this.setDefaultRetryHeaders();
        }
        return this.myHeaders;
    }

    public void setHeaders(HapiMessageHeaders theHeaders) {
        this.myHeaders = theHeaders;
    }

    @Deprecated
    @Nullable
    public String getMessageKeyOrNull() {
        return this.getMessageKey();
    }

    @Nullable
    public String getMessageKey() {
        return null;
    }

    @Nullable
    public String getMessageKeyOrDefault() {
        return Objects.toString(this.getMessageKey(), this.getMessageKeyDefaultValue());
    }

    @Nullable
    protected String getMessageKeyDefaultValue() {
        return null;
    }
}

