/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.binary;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.util.FhirTerser;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseResource;

@Interceptor(order=150)
public class BinarySecurityContextInterceptor {
    private final FhirContext myFhirContext;

    public BinarySecurityContextInterceptor(FhirContext theFhirContext) {
        Validate.notNull((Object)theFhirContext, (String)"theFhirContext must not be null", (Object[])new Object[0]);
        this.myFhirContext = theFhirContext;
    }

    @Hook(value=Pointcut.STORAGE_PRESHOW_RESOURCES)
    public void preShowResources(IPreResourceShowDetails theShowDetails, RequestDetails theRequestDetails) {
        for (IBaseResource nextResource : theShowDetails.getAllResources()) {
            if (!(nextResource instanceof IBaseBinary)) continue;
            this.applyAccessControl((IBaseBinary)nextResource, theRequestDetails);
        }
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED)
    public void preShowResources(IBaseResource theOldValue, IBaseResource theNewValue, RequestDetails theRequestDetails) {
        if (theOldValue instanceof IBaseBinary) {
            this.applyAccessControl((IBaseBinary)theOldValue, theRequestDetails);
        }
    }

    protected void applyAccessControl(IBaseBinary theBinary, RequestDetails theRequestDetails) {
        FhirTerser terser = this.myFhirContext.newTerser();
        String securityContextSystem = terser.getSinglePrimitiveValueOrNull((IBase)theBinary, "securityContext.identifier.system");
        String securityContextValue = terser.getSinglePrimitiveValueOrNull((IBase)theBinary, "securityContext.identifier.value");
        if (StringUtils.isNotBlank((CharSequence)securityContextSystem) || StringUtils.isNotBlank((CharSequence)securityContextValue)) {
            this.applyAccessControl(theBinary, securityContextSystem, securityContextValue, theRequestDetails);
        }
    }

    protected void applyAccessControl(IBaseBinary theBinary, String theSecurityContextSystem, String theSecurityContextValue, RequestDetails theRequestDetails) {
        if (theRequestDetails instanceof SystemRequestDetails) {
            return;
        }
        if (this.securityContextIdentifierAllowed(theSecurityContextSystem, theSecurityContextValue, theRequestDetails)) {
            return;
        }
        this.handleForbidden(theBinary);
    }

    protected void handleForbidden(IBaseBinary theBinary) {
        throw new ForbiddenOperationException(Msg.code((int)2369) + "Security context not permitted");
    }

    protected boolean securityContextIdentifierAllowed(String theSecurityContextSystem, String theSecurityContextValue, RequestDetails theRequestDetails) {
        return false;
    }
}

