/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server.storage;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.InterceptorInvocationTimingEnum;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class TransactionDetails {
    public static final IResourcePersistentId NOT_FOUND = IResourcePersistentId.NOT_FOUND;
    private final Date myTransactionDate;
    private List<Runnable> myRollbackUndoActions = Collections.emptyList();
    private Map<String, IResourcePersistentId> myResolvedResourceIds = Collections.emptyMap();
    private Map<String, IResourcePersistentId> myResolvedMatchUrls = Collections.emptyMap();
    private Map<String, Supplier<IBaseResource>> myResolvedResources = Collections.emptyMap();
    private Set<IResourcePersistentId> myDeletedResourceIds = Collections.emptySet();
    private Set<IResourcePersistentId> myUpdatedResourceIds = Collections.emptySet();
    private Map<String, Object> myUserData;
    private ListMultimap<Pointcut, HookParams> myDeferredInterceptorBroadcasts;
    private EnumSet<Pointcut> myDeferredInterceptorBroadcastPointcuts;
    private boolean myFhirTransaction;
    private List<IIdType> myAutoCreatedPlaceholderResources = Collections.emptyList();

    public TransactionDetails() {
        this(new Date());
    }

    public TransactionDetails(Date theTransactionDate) {
        this.myTransactionDate = theTransactionDate;
    }

    public List<Runnable> getRollbackUndoActions() {
        return Collections.unmodifiableList(this.myRollbackUndoActions);
    }

    public void addRollbackUndoAction(@Nonnull Runnable theRunnable) {
        assert (theRunnable != null);
        if (this.myRollbackUndoActions.isEmpty()) {
            this.myRollbackUndoActions = new ArrayList<Runnable>();
        }
        this.myRollbackUndoActions.add(theRunnable);
    }

    public void clearRollbackUndoActions() {
        if (!this.myRollbackUndoActions.isEmpty()) {
            this.myRollbackUndoActions.clear();
        }
    }

    public void addUpdatedResourceId(@Nonnull IResourcePersistentId theResourceId) {
        Validate.notNull((Object)theResourceId, (String)"theResourceId must not be null", (Object[])new Object[0]);
        if (this.myUpdatedResourceIds.isEmpty()) {
            this.myUpdatedResourceIds = new HashSet<IResourcePersistentId>();
        }
        this.myUpdatedResourceIds.add(theResourceId);
    }

    public void addUpdatedResourceIds(Collection<? extends IResourcePersistentId> theResourceIds) {
        for (IResourcePersistentId iResourcePersistentId : theResourceIds) {
            this.addUpdatedResourceId(iResourcePersistentId);
        }
    }

    public Set<IResourcePersistentId> getUpdatedResourceIds() {
        return this.myUpdatedResourceIds;
    }

    public void addDeletedResourceId(@Nonnull IResourcePersistentId theResourceId) {
        Validate.notNull((Object)theResourceId, (String)"theResourceId must not be null", (Object[])new Object[0]);
        if (this.myDeletedResourceIds.isEmpty()) {
            this.myDeletedResourceIds = new HashSet<IResourcePersistentId>();
        }
        this.myDeletedResourceIds.add(theResourceId);
    }

    public void addDeletedResourceIds(Collection<? extends IResourcePersistentId> theResourceIds) {
        for (IResourcePersistentId iResourcePersistentId : theResourceIds) {
            this.addDeletedResourceId(iResourcePersistentId);
        }
    }

    @Nonnull
    public Set<IResourcePersistentId> getDeletedResourceIds() {
        return Collections.unmodifiableSet(this.myDeletedResourceIds);
    }

    @Nullable
    public IResourcePersistentId getResolvedResourceId(IIdType theId) {
        String idValue = theId.toUnqualifiedVersionless().getValue();
        return this.myResolvedResourceIds.get(idValue);
    }

    @Nullable
    public IBaseResource getResolvedResource(IIdType theId) {
        String idValue = theId.toUnqualifiedVersionless().getValue();
        IBaseResource retVal = null;
        Supplier<IBaseResource> supplier = this.myResolvedResources.get(idValue);
        if (supplier != null) {
            retVal = supplier.get();
        }
        return retVal;
    }

    public boolean isResolvedResourceIdEmpty(IIdType theId) {
        if (this.myResolvedResourceIds != null && this.myResolvedResourceIds.containsKey(theId.toVersionless().getValue())) {
            return this.myResolvedResourceIds.get(theId.toVersionless().getValue()) == null;
        }
        return false;
    }

    public boolean hasResolvedResourceId(IIdType theId) {
        if (this.myResolvedResourceIds != null) {
            return this.myResolvedResourceIds.containsKey(theId.toVersionless().getValue());
        }
        return false;
    }

    public boolean hasNullResolvedResourceId(IIdType theId) {
        String key;
        if (this.myResolvedResourceIds != null && this.myResolvedResourceIds.containsKey(key = theId.toVersionless().getValue())) {
            return this.myResolvedResourceIds.get(key) == null;
        }
        return false;
    }

    public void addResolvedResourceId(IIdType theResourceId, @Nullable IResourcePersistentId thePersistentId) {
        assert (theResourceId != null);
        if (this.myResolvedResourceIds.isEmpty()) {
            this.myResolvedResourceIds = new HashMap<String, IResourcePersistentId>();
        }
        this.myResolvedResourceIds.put(theResourceId.toVersionless().getValue(), thePersistentId);
    }

    public void addResolvedResource(IIdType theResourceId, @Nonnull Supplier<IBaseResource> theResource) {
        assert (theResourceId != null);
        if (this.myResolvedResources.isEmpty()) {
            this.myResolvedResources = new HashMap<String, Supplier<IBaseResource>>();
        }
        this.myResolvedResources.put(theResourceId.toVersionless().getValue(), theResource);
    }

    public void addResolvedResource(IIdType theResourceId, @Nonnull IBaseResource theResource) {
        this.addResolvedResource(theResourceId, () -> theResource);
    }

    public Map<String, IResourcePersistentId> getResolvedMatchUrls() {
        return this.myResolvedMatchUrls;
    }

    public void addResolvedMatchUrl(FhirContext theFhirContext, String theConditionalUrl, @Nonnull IResourcePersistentId<?> thePersistentId) {
        Validate.notBlank((CharSequence)theConditionalUrl, (String)"theConditionalUrl must not be blank", (Object[])new Object[0]);
        Validate.notNull(thePersistentId, (String)"thePersistentId must not be null", (Object[])new Object[0]);
        if (this.myResolvedMatchUrls.isEmpty()) {
            this.myResolvedMatchUrls = new HashMap<String, IResourcePersistentId>();
        } else if (this.matchUrlWithDiffIdExists(theConditionalUrl, thePersistentId)) {
            String msg = theFhirContext.getLocalizer().getMessage(TransactionDetails.class, "invalidMatchUrlMultipleMatches", new Object[]{theConditionalUrl});
            throw new PreconditionFailedException(Msg.code((int)2207) + msg);
        }
        this.myResolvedMatchUrls.put(theConditionalUrl, thePersistentId);
    }

    public void removeResolvedMatchUrl(String theMatchUrl) {
        this.myResolvedMatchUrls.remove(theMatchUrl);
    }

    private boolean matchUrlWithDiffIdExists(String theConditionalUrl, @Nonnull IResourcePersistentId thePersistentId) {
        if (this.myResolvedMatchUrls.containsKey(theConditionalUrl) && this.myResolvedMatchUrls.get(theConditionalUrl) != NOT_FOUND) {
            return !this.myResolvedMatchUrls.get(theConditionalUrl).getId().equals(thePersistentId.getId());
        }
        return false;
    }

    public Date getTransactionDate() {
        return this.myTransactionDate;
    }

    public void clearUserData(String theKey) {
        if (this.myUserData != null) {
            this.myUserData.remove(theKey);
        }
    }

    public void putUserData(String theKey, Object theValue) {
        if (this.myUserData == null) {
            this.myUserData = new HashMap<String, Object>();
        }
        this.myUserData.put(theKey, theValue);
    }

    public <T> T getUserData(String theKey) {
        if (this.myUserData != null) {
            return (T)this.myUserData.get(theKey);
        }
        return null;
    }

    public <T> T getOrCreateUserData(String theKey, Supplier<T> theSupplier) {
        T retVal = this.getUserData(theKey);
        if (retVal == null) {
            retVal = theSupplier.get();
            this.putUserData(theKey, retVal);
        }
        return retVal;
    }

    public void beginAcceptingDeferredInterceptorBroadcasts(Pointcut ... thePointcuts) {
        Validate.isTrue((!this.isAcceptingDeferredInterceptorBroadcasts() ? 1 : 0) != 0);
        this.myDeferredInterceptorBroadcasts = ArrayListMultimap.create();
        this.myDeferredInterceptorBroadcastPointcuts = EnumSet.of(thePointcuts[0], thePointcuts);
    }

    public boolean isAcceptingDeferredInterceptorBroadcasts() {
        return this.myDeferredInterceptorBroadcasts != null;
    }

    public boolean isAcceptingDeferredInterceptorBroadcasts(Pointcut thePointcut) {
        return this.myDeferredInterceptorBroadcasts != null && this.myDeferredInterceptorBroadcastPointcuts.contains(thePointcut);
    }

    public ListMultimap<Pointcut, HookParams> endAcceptingDeferredInterceptorBroadcasts() {
        Validate.isTrue((boolean)this.isAcceptingDeferredInterceptorBroadcasts());
        ListMultimap<Pointcut, HookParams> retVal = this.myDeferredInterceptorBroadcasts;
        this.myDeferredInterceptorBroadcasts = null;
        this.myDeferredInterceptorBroadcastPointcuts = null;
        return retVal;
    }

    public void addDeferredInterceptorBroadcast(Pointcut thePointcut, HookParams theHookParams) {
        Validate.isTrue((boolean)this.isAcceptingDeferredInterceptorBroadcasts(thePointcut));
        this.myDeferredInterceptorBroadcasts.put((Object)thePointcut, (Object)theHookParams);
    }

    public InterceptorInvocationTimingEnum getInvocationTiming(Pointcut thePointcut) {
        if (this.myDeferredInterceptorBroadcasts == null) {
            return InterceptorInvocationTimingEnum.ACTIVE;
        }
        List hookParams = this.myDeferredInterceptorBroadcasts.get((Object)thePointcut);
        return hookParams == null ? InterceptorInvocationTimingEnum.ACTIVE : InterceptorInvocationTimingEnum.DEFERRED;
    }

    public void deferredBroadcastProcessingFinished() {
    }

    public void clearResolvedItems() {
        this.myResolvedResourceIds.clear();
        this.myResolvedMatchUrls.clear();
    }

    public boolean hasResolvedResourceIds() {
        return !this.myResolvedResourceIds.isEmpty();
    }

    public boolean isFhirTransaction() {
        return this.myFhirTransaction;
    }

    public void setFhirTransaction(boolean theFhirTransaction) {
        this.myFhirTransaction = theFhirTransaction;
    }

    public void addAutoCreatedPlaceholderResource(IIdType theResource) {
        if (this.myAutoCreatedPlaceholderResources.isEmpty()) {
            this.myAutoCreatedPlaceholderResources = new ArrayList<IIdType>();
        }
        this.myAutoCreatedPlaceholderResources.add(theResource);
    }

    @Nonnull
    public List<IIdType> getAutoCreatedPlaceholderResourcesAndClear() {
        List<IIdType> retVal = this.myAutoCreatedPlaceholderResources;
        if (!this.myAutoCreatedPlaceholderResources.isEmpty()) {
            this.myAutoCreatedPlaceholderResources = Collections.emptyList();
        }
        return retVal;
    }
}

