/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.util;

import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletSubRequestDetails;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class ServletRequestUtil {
    public static ServletSubRequestDetails getServletSubRequestDetails(ServletRequestDetails theRequestDetails, String url, ArrayListMultimap<String, String> theParamValues) {
        ServletSubRequestDetails requestDetails = new ServletSubRequestDetails(theRequestDetails);
        requestDetails.setServletRequest(theRequestDetails.getServletRequest());
        requestDetails.setRequestType(RequestTypeEnum.GET);
        requestDetails.setServer(theRequestDetails.getServer());
        int qIndex = url.indexOf(63);
        requestDetails.setParameters(new HashMap<String, String[]>());
        if (qIndex != -1) {
            String params = url.substring(qIndex);
            List parameters = UrlUtil.translateMatchUrl((String)params);
            for (NameValuePair nameValuePair : parameters) {
                theParamValues.put((Object)nameValuePair.getName(), (Object)nameValuePair.getValue());
            }
            for (Map.Entry entry : theParamValues.asMap().entrySet()) {
                String[] nextValue = ((Collection)entry.getValue()).toArray(new String[((Collection)entry.getValue()).size()]);
                requestDetails.addParameter((String)entry.getKey(), nextValue);
            }
            url = url.substring(0, qIndex);
        }
        if (url.length() > 0 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        requestDetails.setRequestPath(url);
        requestDetails.setFhirServerBase(theRequestDetails.getFhirServerBase());
        requestDetails.setTenantId(theRequestDetails.getTenantId());
        theRequestDetails.getServer().populateRequestDetailsFromRequestPath(requestDetails, url);
        return requestDetails;
    }
}

