/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.util;

import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.phonetic.IPhoneticEncoder;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.hl7.fhir.instance.model.api.IIdType;

public interface ISearchParamRegistry {
    default public boolean isInitialized() {
        return true;
    }

    @Deprecated(since="8.0.0", forRemoval=true)
    default public RuntimeSearchParam getActiveSearchParam(String theResourceName, String theParamName) {
        return this.getActiveSearchParam(theResourceName, theParamName, SearchParamLookupContextEnum.ALL);
    }

    public RuntimeSearchParam getActiveSearchParam(@Nonnull String var1, @Nonnull String var2, @Nonnull SearchParamLookupContextEnum var3);

    @Deprecated(since="8.0.0", forRemoval=true)
    default public ResourceSearchParams getActiveSearchParams(String theResourceName) {
        return this.getActiveSearchParams(theResourceName, SearchParamLookupContextEnum.ALL);
    }

    public ResourceSearchParams getActiveSearchParams(@Nonnull String var1, @Nonnull SearchParamLookupContextEnum var2);

    default public void forceRefresh() {
    }

    default public void requestRefresh() {
    }

    default public void setPhoneticEncoder(IPhoneticEncoder thePhoneticEncoder) {
    }

    default public List<RuntimeSearchParam> getActiveComboSearchParams(@Nonnull String theResourceName, @Nonnull SearchParamLookupContextEnum theContext) {
        return Collections.emptyList();
    }

    default public List<RuntimeSearchParam> getActiveComboSearchParams(@Nonnull String theResourceName, @Nonnull ComboSearchParamType theParamType, @Nonnull SearchParamLookupContextEnum theContext) {
        return Collections.emptyList();
    }

    default public Optional<RuntimeSearchParam> getActiveComboSearchParamById(@Nonnull String theResourceName, @Nonnull IIdType theId) {
        return Optional.empty();
    }

    default public List<RuntimeSearchParam> getActiveComboSearchParams(@Nonnull String theResourceName, @Nonnull Set<String> theParamNames, @Nonnull SearchParamLookupContextEnum theContext) {
        return Collections.emptyList();
    }

    default public Collection<String> getValidSearchParameterNamesIncludingMeta(@Nonnull String theResourceName, @Nonnull SearchParamLookupContextEnum theContext) {
        ResourceSearchParams activeSearchParams = this.getActiveSearchParams(theResourceName, theContext);
        TreeSet<Object> retval = activeSearchParams == null ? new TreeSet<String>() : new TreeSet<String>(activeSearchParams.getSearchParamNames());
        retval.add("_id");
        retval.add("_lastUpdated");
        return retval;
    }

    @Nullable
    public RuntimeSearchParam getActiveSearchParamByUrl(@Nonnull String var1, @Nonnull SearchParamLookupContextEnum var2);

    default public RuntimeSearchParam getRuntimeSearchParam(@Nonnull String theResourceType, @Nonnull String theParamName, @Nonnull SearchParamLookupContextEnum theContext) {
        RuntimeSearchParam availableSearchParamDef = this.getActiveSearchParam(theResourceType, theParamName, theContext);
        if (availableSearchParamDef == null) {
            availableSearchParamDef = this.getActiveSearchParam("Resource", theParamName, theContext);
        }
        if (availableSearchParamDef == null) {
            throw new InvalidRequestException(Msg.code((int)1209) + "Unknown parameter name: " + theResourceType + ":" + theParamName);
        }
        return availableSearchParamDef;
    }

    default public ResourceSearchParams getRuntimeSearchParams(@Nonnull String theResourceType, @Nonnull SearchParamLookupContextEnum theContext) {
        ResourceSearchParams availableSearchParams = this.getActiveSearchParams(theResourceType, theContext).makeCopy();
        ResourceSearchParams resourceSearchParams = this.getActiveSearchParams("Resource", theContext);
        resourceSearchParams.getSearchParamNames().forEach(param -> availableSearchParams.addSearchParamIfAbsent((String)param, resourceSearchParams.get((String)param)));
        return availableSearchParams;
    }

    public static boolean isAllowedForContext(@Nonnull RuntimeSearchParam theSearchParam, @Nullable SearchParamLookupContextEnum theContext) {
        if (theContext == SearchParamLookupContextEnum.SEARCH || theContext == SearchParamLookupContextEnum.SORT) {
            return theSearchParam.isEnabledForSearching();
        }
        return true;
    }

    public static enum SearchParamLookupContextEnum {
        INDEX,
        SEARCH,
        SORT,
        ALL;

    }
}

