/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.util;

import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.phonetic.IPhoneticEncoder;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IIdType;

public class FhirContextSearchParamRegistry
implements ISearchParamRegistry {
    private final List<RuntimeSearchParam> myExtraSearchParams = new ArrayList<RuntimeSearchParam>();
    private final FhirContext myCtx;

    public FhirContextSearchParamRegistry(@Nonnull FhirContext theCtx) {
        Validate.notNull((Object)theCtx, (String)"theCtx must not be null", (Object[])new Object[0]);
        this.myCtx = theCtx;
    }

    @Override
    public void forceRefresh() {
    }

    @Override
    public RuntimeSearchParam getActiveSearchParam(@Nonnull String theResourceName, @Nonnull String theParamName, @Nonnull ISearchParamRegistry.SearchParamLookupContextEnum theContext) {
        return this.getActiveSearchParams(theResourceName, theContext).get(theParamName);
    }

    @Override
    public ResourceSearchParams getActiveSearchParams(@Nonnull String theResourceName, @Nonnull ISearchParamRegistry.SearchParamLookupContextEnum theContext) {
        ResourceSearchParams retval = new ResourceSearchParams(theResourceName);
        RuntimeResourceDefinition nextResDef = this.myCtx.getResourceDefinition(theResourceName);
        for (RuntimeSearchParam nextSp : nextResDef.getSearchParams()) {
            if (!ISearchParamRegistry.isAllowedForContext(nextSp, theContext)) continue;
            retval.put(nextSp.getName(), nextSp);
        }
        for (RuntimeSearchParam next : this.myExtraSearchParams) {
            if (!ISearchParamRegistry.isAllowedForContext(next, theContext)) continue;
            retval.put(next.getName(), next);
        }
        return retval;
    }

    public void addSearchParam(RuntimeSearchParam theSearchParam) {
        this.myExtraSearchParams.add(theSearchParam);
    }

    @Override
    public List<RuntimeSearchParam> getActiveComboSearchParams(@Nonnull String theResourceName, @Nonnull Set<String> theParamNames, @Nonnull ISearchParamRegistry.SearchParamLookupContextEnum theContext) {
        throw new UnsupportedOperationException(Msg.code((int)2066));
    }

    @Override
    @Nullable
    public RuntimeSearchParam getActiveSearchParamByUrl(@Nonnull String theUrl, @Nonnull ISearchParamRegistry.SearchParamLookupContextEnum theContext) {
        return this.myCtx.getResourceTypes().stream().flatMap(type -> this.getActiveSearchParams((String)type, theContext).values().stream()).filter(rsp -> theUrl.equals(rsp.getUri())).findFirst().orElse(null);
    }

    @Override
    public List<RuntimeSearchParam> getActiveComboSearchParams(@Nonnull String theResourceName, @Nonnull ISearchParamRegistry.SearchParamLookupContextEnum theContext) {
        throw new UnsupportedOperationException(Msg.code((int)2068));
    }

    @Override
    public List<RuntimeSearchParam> getActiveComboSearchParams(@Nonnull String theResourceName, @Nonnull ComboSearchParamType theParamType, @Nonnull ISearchParamRegistry.SearchParamLookupContextEnum theContext) {
        throw new UnsupportedOperationException(Msg.code((int)2209));
    }

    @Override
    public Optional<RuntimeSearchParam> getActiveComboSearchParamById(@Nonnull String theResourceName, @Nonnull IIdType theId) {
        throw new UnsupportedOperationException(Msg.code((int)2211));
    }

    @Override
    public void requestRefresh() {
    }

    @Override
    public void setPhoneticEncoder(IPhoneticEncoder thePhoneticEncoder) {
    }
}

