/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.annotation.Update;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseOutcomeReturningMethodBindingWithResourceParam;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class UpdateMethodBinding
extends BaseOutcomeReturningMethodBindingWithResourceParam {
    public UpdateMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, Update.class, theProvider);
    }

    @Override
    protected void addParametersForServerRequest(RequestDetails theRequest, Object[] theParams) {
        IIdType id = theRequest.getId();
        id = UpdateMethodBinding.applyETagAsVersion(theRequest, id);
        if (theRequest.getId() != null && !theRequest.getId().hasVersionIdPart() && id != null && id.hasVersionIdPart()) {
            theRequest.getId().setValue(id.getValue());
        }
        super.addParametersForServerRequest(theRequest, theParams);
    }

    public static IIdType applyETagAsVersion(RequestDetails theRequest, IIdType theId) {
        String ifMatchValue = theRequest.getHeader("If-Match");
        return UpdateMethodBinding.applyETagAsVersion(ifMatchValue, theId);
    }

    public static IIdType applyETagAsVersion(String theIfMatchValue, IIdType theId) {
        if (StringUtils.isNotBlank((CharSequence)theIfMatchValue)) {
            theIfMatchValue = ParameterUtil.parseETagValue((String)theIfMatchValue);
            if (theId != null && !theId.hasVersionIdPart()) {
                theId = theId.withVersion(theIfMatchValue);
            }
        }
        return theId;
    }

    @Override
    protected String getMatchingOperation() {
        return null;
    }

    @Override
    @Nonnull
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.UPDATE;
    }

    @Override
    protected Set<RequestTypeEnum> provideAllowableRequestTypes() {
        return Collections.singleton(RequestTypeEnum.PUT);
    }

    @Override
    protected void validateResourceIdAndUrlIdForNonConditionalOperation(IBaseResource theResource, String theResourceId, String theUrlId, String theMatchUrl) {
        if (StringUtils.isBlank((CharSequence)theMatchUrl)) {
            if (StringUtils.isBlank((CharSequence)theUrlId)) {
                String msg = this.getContext().getLocalizer().getMessage(BaseOutcomeReturningMethodBindingWithResourceParam.class, "noIdInUrlForUpdate", new Object[0]);
                throw new InvalidRequestException(Msg.code((int)418) + msg);
            }
            if (StringUtils.isBlank((CharSequence)theResourceId)) {
                String msg = this.getContext().getLocalizer().getMessage(BaseOutcomeReturningMethodBindingWithResourceParam.class, "noIdInBodyForUpdate", new Object[0]);
                throw new InvalidRequestException(Msg.code((int)419) + msg);
            }
            if (!theResourceId.equals(theUrlId)) {
                String msg = this.getContext().getLocalizer().getMessage(BaseOutcomeReturningMethodBindingWithResourceParam.class, "incorrectIdForUpdate", new Object[]{theResourceId, theUrlId});
                throw new InvalidRequestException(Msg.code((int)420) + msg);
            }
        } else {
            theResource.setId((IIdType)null);
        }
    }
}

