/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.annotation.ConditionalUrlParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import java.lang.reflect.Method;
import java.util.Collection;

class ConditionalParamBinder
implements IParameter {
    private boolean mySupportsMultiple;

    ConditionalParamBinder(boolean theSupportsMultiple) {
        this.mySupportsMultiple = theSupportsMultiple;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null || theInnerCollectionType != null || !theParameterType.equals(String.class)) {
            throw new ConfigurationException(Msg.code((int)409) + "Parameters annotated with @" + ConditionalUrlParam.class.getSimpleName() + " must be of type String, found incorrect parameter in method \"" + String.valueOf(theMethod) + "\"");
        }
    }

    public boolean isSupportsMultiple() {
        return this.mySupportsMultiple;
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding theMethodBinding) throws InternalErrorException, InvalidRequestException {
        return theRequest.getConditionalUrl(theMethodBinding.getRestOperationType());
    }
}

