/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.BundleLinks;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.OffsetCalculator;
import ca.uhn.fhir.rest.server.method.ResponseBundleBuilder;
import ca.uhn.fhir.rest.server.method.ResponseBundleRequest;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ReflectionUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class BaseResourceReturningMethodBinding
extends BaseMethodBinding {
    protected final ResponseBundleBuilder myResponseBundleBuilder;
    private MethodReturnTypeEnum myMethodReturnType;
    private String myResourceName;

    public BaseResourceReturningMethodBinding(Class<?> theReturnResourceType, Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, theProvider);
        Class<?> methodReturnType = theMethod.getReturnType();
        Set<Class<?>> expectedReturnTypes = this.provideExpectedReturnTypes();
        if (expectedReturnTypes != null) {
            Validate.isTrue((boolean)expectedReturnTypes.contains(methodReturnType), (String)"Unexpected method return type on %s - Allowed: %s", (Object[])new Object[]{theMethod, expectedReturnTypes});
        } else if (Collection.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.LIST_OF_RESOURCES;
            Class collectionType = ReflectionUtil.getGenericCollectionTypeOfMethodReturnType((Method)theMethod);
            if (collectionType != null && !Object.class.equals((Object)collectionType) && !IBaseResource.class.isAssignableFrom(collectionType)) {
                throw new ConfigurationException(Msg.code((int)433) + "Method " + theMethod.getDeclaringClass().getSimpleName() + "#" + theMethod.getName() + " returns an invalid collection generic type: " + String.valueOf(collectionType));
            }
        } else if (IBaseResource.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = IBaseBundle.class.isAssignableFrom(methodReturnType) ? MethodReturnTypeEnum.BUNDLE_RESOURCE : MethodReturnTypeEnum.RESOURCE;
        } else if (IBundleProvider.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.BUNDLE_PROVIDER;
        } else if (MethodOutcome.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.METHOD_OUTCOME;
        } else if (Void.TYPE.equals(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.VOID;
        } else {
            throw new ConfigurationException(Msg.code((int)434) + "Invalid return type '" + methodReturnType.getCanonicalName() + "' on method '" + theMethod.getName() + "' on type: " + theMethod.getDeclaringClass().getCanonicalName());
        }
        if (theReturnResourceType != null && IBaseResource.class.isAssignableFrom(theReturnResourceType) && !Modifier.isAbstract(theReturnResourceType.getModifiers()) && !Modifier.isInterface(theReturnResourceType.getModifiers())) {
            Class<?> resourceType = theReturnResourceType;
            RuntimeResourceDefinition resourceDefinition = theContext.getResourceDefinition(resourceType);
            this.myResourceName = resourceDefinition.getName();
        }
        this.myResponseBundleBuilder = new ResponseBundleBuilder(this.isOffsetModeHistory());
    }

    protected Set<Class<?>> provideExpectedReturnTypes() {
        return null;
    }

    protected boolean isOffsetModeHistory() {
        return false;
    }

    public IBaseResource doInvokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) {
        IBaseResource responseObject;
        Object[] params = this.createMethodParams(theRequest);
        Object resultObj = this.invokeServer(theServer, theRequest, params);
        if (resultObj == null) {
            return null;
        }
        Integer count = RestfulServerUtils.extractCountParameter(theRequest);
        switch (this.getReturnType()) {
            case BUNDLE: {
                BundleTypeEnum responseBundleType = this.getResponseBundleType();
                BundleLinks bundleLinks = new BundleLinks(theRequest.getServerBaseForRequest(), null, RestfulServerUtils.prettyPrintResponse(theServer, theRequest), responseBundleType);
                String linkSelf = RestfulServerUtils.createLinkSelf(theRequest.getFhirServerBase(), theRequest);
                bundleLinks.setSelf(linkSelf);
                if (this.getMethodReturnType() == MethodReturnTypeEnum.BUNDLE_RESOURCE) {
                    IPrimitiveType<Date> lastUpdated;
                    IBaseResource resource;
                    if (resultObj instanceof IBundleProvider) {
                        IBundleProvider result = (IBundleProvider)resultObj;
                        resource = result.getResources(0, 1).get(0);
                        lastUpdated = result.getPublished();
                    } else {
                        resource = (IBaseResource)resultObj;
                        lastUpdated = theServer.getFhirContext().getVersion().getLastUpdated(resource);
                    }
                    IVersionSpecificBundleFactory bundleFactory = theServer.getFhirContext().newBundleFactory();
                    bundleFactory.initializeWithBundleResource(resource);
                    bundleFactory.addRootPropertiesToBundle(null, bundleLinks, count, lastUpdated);
                    responseObject = resource;
                    break;
                }
                ResponseBundleRequest responseBundleRequest = this.buildResponseBundleRequest(theServer, theRequest, params, (IBundleProvider)resultObj, count, responseBundleType, linkSelf);
                responseObject = this.myResponseBundleBuilder.buildResponseBundle(responseBundleRequest);
                break;
            }
            case RESOURCE: {
                IBundleProvider result = (IBundleProvider)resultObj;
                Integer size = result.size();
                if (size == null || size == 0) {
                    throw new ResourceNotFoundException(Msg.code((int)436) + "Resource " + String.valueOf(theRequest.getId()) + " is not known");
                }
                if (size > 1) {
                    throw new InternalErrorException(Msg.code((int)437) + "Method returned multiple resources");
                }
                responseObject = result.getResources(0, 1).get(0);
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code((int)438));
            }
        }
        return responseObject;
    }

    private ResponseBundleRequest buildResponseBundleRequest(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theParams, IBundleProvider theBundleProvider, Integer theCount, BundleTypeEnum theBundleTypeEnum, String theLinkSelf) {
        Set<Include> includes = this.getRequestIncludesFromParams(theParams);
        if (theCount == null) {
            theCount = theBundleProvider.preferredPageSize();
        }
        int offset = OffsetCalculator.calculateOffset(theRequest, theBundleProvider);
        return new ResponseBundleRequest(theServer, theBundleProvider, theRequest, offset, theCount, theLinkSelf, includes, theBundleTypeEnum, null);
    }

    public MethodReturnTypeEnum getMethodReturnType() {
        return this.myMethodReturnType;
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    protected void setResourceName(String theResourceName) {
        this.myResourceName = theResourceName;
    }

    protected abstract BundleTypeEnum getResponseBundleType();

    public abstract ReturnTypeEnum getReturnType();

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) throws BaseServerResponseException, IOException {
        HttpServletResponse servletResponse;
        IBaseResource response = this.doInvokeServer(theServer, theRequest);
        int responseCode = 200;
        if (theRequest instanceof ServletRequestDetails && (servletResponse = ((ServletRequestDetails)theRequest).getServletResponse()) != null && servletResponse.getStatus() > 0) {
            responseCode = servletResponse.getStatus();
        }
        if (response == null) {
            ResponseDetails responseDetails = new ResponseDetails();
            responseDetails.setResponseCode(responseCode);
            BaseResourceReturningMethodBinding.callOutgoingResponseHook(theRequest, responseDetails);
            return null;
        }
        Set<SummaryEnum> summaryMode = RestfulServerUtils.determineSummaryMode(theRequest);
        ResponseDetails responseDetails = new ResponseDetails();
        responseDetails.setResponseResource(response);
        responseDetails.setResponseCode(responseCode);
        if (!BaseResourceReturningMethodBinding.callOutgoingResponseHook(theRequest, responseDetails)) {
            return null;
        }
        return RestfulServerUtils.streamResponseAsResource(theServer, responseDetails.getResponseResource(), summaryMode, responseDetails.getResponseCode(), this.isAddContentLocationHeader(), theRequest.isRespondGzip(), theRequest, null, null);
    }

    public abstract Object invokeServer(IRestfulServer<?> var1, RequestDetails var2, Object[] var3) throws InvalidRequestException, InternalErrorException;

    protected boolean isAddContentLocationHeader() {
        return true;
    }

    public static boolean callOutgoingResponseHook(RequestDetails theRequest, ResponseDetails theResponseDetails) {
        HttpServletRequest servletRequest = null;
        HttpServletResponse servletResponse = null;
        if (theRequest instanceof ServletRequestDetails) {
            servletRequest = ((ServletRequestDetails)theRequest).getServletRequest();
            servletResponse = ((ServletRequestDetails)theRequest).getServletResponse();
        }
        HookParams responseParams = new HookParams();
        responseParams.add(RequestDetails.class, (Object)theRequest);
        responseParams.addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
        responseParams.add(IBaseResource.class, (Object)theResponseDetails.getResponseResource());
        responseParams.add(ResponseDetails.class, (Object)theResponseDetails);
        responseParams.add(HttpServletRequest.class, (Object)servletRequest);
        responseParams.add(HttpServletResponse.class, (Object)servletResponse);
        if (theRequest.getInterceptorBroadcaster() != null) {
            return theRequest.getInterceptorBroadcaster().callHooks((IPointcut)Pointcut.SERVER_OUTGOING_RESPONSE, responseParams);
        }
        return true;
    }

    public static void callOutgoingFailureOperationOutcomeHook(RequestDetails theRequestDetails, IBaseOperationOutcome theOperationOutcome) {
        HookParams responseParams = new HookParams();
        responseParams.add(RequestDetails.class, (Object)theRequestDetails);
        responseParams.addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails);
        responseParams.add(IBaseOperationOutcome.class, (Object)theOperationOutcome);
        if (theRequestDetails.getInterceptorBroadcaster() != null) {
            theRequestDetails.getInterceptorBroadcaster().callHooks((IPointcut)Pointcut.SERVER_OUTGOING_FAILURE_OPERATIONOUTCOME, responseParams);
        }
    }

    public static enum MethodReturnTypeEnum {
        BUNDLE,
        BUNDLE_PROVIDER,
        BUNDLE_RESOURCE,
        LIST_OF_RESOURCES,
        METHOD_OUTCOME,
        VOID,
        RESOURCE;

    }

    public static enum ReturnTypeEnum {
        BUNDLE,
        RESOURCE;

    }
}

