/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.consent;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.interceptor.consent.ConsentOperationStatusEnum;
import ca.uhn.fhir.rest.server.interceptor.consent.ConsentOutcome;
import ca.uhn.fhir.rest.server.interceptor.consent.IConsentContextServices;
import ca.uhn.fhir.rest.server.interceptor.consent.IConsentService;
import ca.uhn.fhir.rest.server.util.ICachedSearchDetails;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.IModelVisitor2;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;

@Interceptor(order=100)
public class ConsentInterceptor {
    private static final AtomicInteger ourInstanceCount = new AtomicInteger(0);
    private final int myInstanceIndex = ourInstanceCount.incrementAndGet();
    private final String myRequestAuthorizedKey = ConsentInterceptor.class.getName() + "_" + this.myInstanceIndex + "_AUTHORIZED";
    private final String myRequestCompletedKey = ConsentInterceptor.class.getName() + "_" + this.myInstanceIndex + "_COMPLETED";
    private final String myRequestSeenResourcesKey = ConsentInterceptor.class.getName() + "_" + this.myInstanceIndex + "_SEENRESOURCES";
    private volatile List<IConsentService> myConsentService = Collections.emptyList();
    private IConsentContextServices myContextConsentServices = IConsentContextServices.NULL_IMPL;

    public ConsentInterceptor() {
    }

    public ConsentInterceptor(IConsentService theConsentService) {
        this(theConsentService, IConsentContextServices.NULL_IMPL);
    }

    public ConsentInterceptor(IConsentService theConsentService, IConsentContextServices theContextConsentServices) {
        this.setConsentService(theConsentService);
        this.setContextConsentServices(theContextConsentServices);
    }

    public void setContextConsentServices(IConsentContextServices theContextConsentServices) {
        Validate.notNull((Object)theContextConsentServices, (String)"theContextConsentServices must not be null", (Object[])new Object[0]);
        this.myContextConsentServices = theContextConsentServices;
    }

    @Deprecated
    public void setConsentService(IConsentService theConsentService) {
        Validate.notNull((Object)theConsentService, (String)"theConsentService must not be null", (Object[])new Object[0]);
        this.myConsentService = Collections.singletonList(theConsentService);
    }

    public ConsentInterceptor registerConsentService(IConsentService theConsentService) {
        Validate.notNull((Object)theConsentService, (String)"theConsentService must not be null", (Object[])new Object[0]);
        ArrayList<IConsentService> newList = new ArrayList<IConsentService>(this.myConsentService.size() + 1);
        newList.addAll(this.myConsentService);
        newList.add(theConsentService);
        this.myConsentService = newList;
        return this;
    }

    public ConsentInterceptor unregisterConsentService(IConsentService theConsentService) {
        Validate.notNull((Object)theConsentService, (String)"theConsentService must not be null", (Object[])new Object[0]);
        List newList = this.myConsentService.stream().filter(t -> t != theConsentService).collect(Collectors.toList());
        this.myConsentService = newList;
        return this;
    }

    @VisibleForTesting
    public List<IConsentService> getConsentServices() {
        return Collections.unmodifiableList(this.myConsentService);
    }

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED)
    public void interceptPreHandled(RequestDetails theRequestDetails) {
        if (this.isSkipServiceForRequest(theRequestDetails)) {
            return;
        }
        this.validateParameter(theRequestDetails.getParameters());
        block5: for (IConsentService nextService : this.myConsentService) {
            ConsentOutcome outcome = nextService.startOperation(theRequestDetails, this.myContextConsentServices);
            Validate.notNull((Object)outcome, (String)"Consent service returned null outcome", (Object[])new Object[0]);
            switch (outcome.getStatus()) {
                case REJECT: {
                    throw ConsentInterceptor.toForbiddenOperationException(outcome);
                }
                case PROCEED: {
                    continue block5;
                }
                case AUTHORIZED: {
                    Map<Object, Object> userData = theRequestDetails.getUserData();
                    userData.put(this.myRequestAuthorizedKey, Boolean.TRUE);
                    return;
                }
            }
        }
    }

    @Hook(value=Pointcut.STORAGE_PRECHECK_FOR_CACHED_SEARCH)
    public boolean interceptPreCheckForCachedSearch(@Nonnull RequestDetails theRequestDetails) {
        return !this.isProcessCanSeeResource(theRequestDetails, null);
    }

    @Hook(value=Pointcut.STORAGE_PRESEARCH_REGISTERED)
    public void interceptPreSearchRegistered(RequestDetails theRequestDetails, ICachedSearchDetails theCachedSearchDetails) {
        if (this.isProcessCanSeeResource(theRequestDetails, null)) {
            theCachedSearchDetails.setCannotBeReused();
        }
    }

    @Hook(value=Pointcut.STORAGE_PREACCESS_RESOURCES)
    public void interceptPreAccess(RequestDetails theRequestDetails, IPreResourceAccessDetails thePreResourceAccessDetails) {
        boolean[] processConsentSvcs = new boolean[this.myConsentService.size()];
        boolean processAnyConsentSvcs = this.isProcessCanSeeResource(theRequestDetails, processConsentSvcs);
        if (!processAnyConsentSvcs) {
            return;
        }
        IdentityHashMap<IBaseResource, ConsentOperationStatusEnum> alreadySeenResources = this.getAlreadySeenResourcesMap(theRequestDetails);
        block5: for (int resourceIdx = 0; resourceIdx < thePreResourceAccessDetails.size(); ++resourceIdx) {
            IBaseResource nextResource = thePreResourceAccessDetails.getResource(resourceIdx);
            for (int consentSvcIdx = 0; consentSvcIdx < this.myConsentService.size(); ++consentSvcIdx) {
                IConsentService nextService = this.myConsentService.get(consentSvcIdx);
                if (!processConsentSvcs[consentSvcIdx]) continue;
                ConsentOutcome outcome = nextService.canSeeResource(theRequestDetails, nextResource, this.myContextConsentServices);
                Validate.notNull((Object)outcome, (String)"Consent service returned null outcome", (Object[])new Object[0]);
                Validate.isTrue((outcome.getResource() == null ? 1 : 0) != 0, (String)"Consent service returned a resource in its outcome. This is not permitted in canSeeResource(..)", (Object[])new Object[0]);
                boolean skipSubsequentServices = false;
                switch (outcome.getStatus()) {
                    case PROCEED: {
                        break;
                    }
                    case AUTHORIZED: {
                        alreadySeenResources.put(nextResource, ConsentOperationStatusEnum.AUTHORIZED);
                        skipSubsequentServices = true;
                        break;
                    }
                    case REJECT: {
                        alreadySeenResources.put(nextResource, ConsentOperationStatusEnum.REJECT);
                        thePreResourceAccessDetails.setDontReturnResourceAtIndex(resourceIdx);
                        skipSubsequentServices = true;
                    }
                }
                if (skipSubsequentServices) continue block5;
            }
        }
    }

    private boolean isProcessCanSeeResource(@Nonnull RequestDetails theRequestDetails, @Nullable boolean[] theProcessConsentSvcsFlags) {
        if (this.isRequestAuthorized(theRequestDetails)) {
            return false;
        }
        if (this.isSkipServiceForRequest(theRequestDetails)) {
            return false;
        }
        if (this.myConsentService.isEmpty()) {
            return false;
        }
        if (theProcessConsentSvcsFlags == null) {
            theProcessConsentSvcsFlags = new boolean[this.myConsentService.size()];
        }
        Validate.isTrue((theProcessConsentSvcsFlags.length == this.myConsentService.size() ? 1 : 0) != 0);
        boolean processAnyConsentSvcs = false;
        for (int consentSvcIdx = 0; consentSvcIdx < this.myConsentService.size(); ++consentSvcIdx) {
            IConsentService nextService = this.myConsentService.get(consentSvcIdx);
            boolean shouldCallCanSeeResource = nextService.shouldProcessCanSeeResource(theRequestDetails, this.myContextConsentServices);
            processAnyConsentSvcs |= shouldCallCanSeeResource;
            theProcessConsentSvcsFlags[consentSvcIdx] = shouldCallCanSeeResource;
        }
        return processAnyConsentSvcs;
    }

    @Hook(value=Pointcut.STORAGE_PRESHOW_RESOURCES)
    public void interceptPreShow(RequestDetails theRequestDetails, IPreResourceShowDetails thePreResourceShowDetails) {
        if (this.isRequestAuthorized(theRequestDetails)) {
            return;
        }
        if (this.isAllowListedRequest(theRequestDetails)) {
            return;
        }
        if (this.isSkipServiceForRequest(theRequestDetails)) {
            return;
        }
        if (this.myConsentService.isEmpty()) {
            return;
        }
        IdentityHashMap<IBaseResource, ConsentOperationStatusEnum> alreadySeenResources = this.getAlreadySeenResourcesMap(theRequestDetails);
        for (int i = 0; i < thePreResourceShowDetails.size(); ++i) {
            IBaseResource resource = thePreResourceShowDetails.getResource(i);
            if (resource == null || alreadySeenResources.putIfAbsent(resource, ConsentOperationStatusEnum.PROCEED) != null) continue;
            block6: for (IConsentService nextService : this.myConsentService) {
                ConsentOutcome nextOutcome = nextService.willSeeResource(theRequestDetails, resource, this.myContextConsentServices);
                IBaseResource newResource = nextOutcome.getResource();
                switch (nextOutcome.getStatus()) {
                    case PROCEED: {
                        if (newResource == null) continue block6;
                        thePreResourceShowDetails.setResource(i, newResource);
                        resource = newResource;
                        continue block6;
                    }
                    case AUTHORIZED: {
                        alreadySeenResources.put(resource, ConsentOperationStatusEnum.AUTHORIZED);
                        if (newResource == null) continue block6;
                        thePreResourceShowDetails.setResource(i, newResource);
                        continue block6;
                    }
                    case REJECT: {
                        alreadySeenResources.put(resource, ConsentOperationStatusEnum.REJECT);
                        if (nextOutcome.getOperationOutcome() != null) {
                            IBaseOperationOutcome newOperationOutcome = nextOutcome.getOperationOutcome();
                            thePreResourceShowDetails.setResource(i, (IBaseResource)newOperationOutcome);
                            alreadySeenResources.put((IBaseResource)newOperationOutcome, ConsentOperationStatusEnum.PROCEED);
                            continue block6;
                        }
                        resource = null;
                        thePreResourceShowDetails.setResource(i, null);
                        continue block6;
                    }
                }
            }
        }
    }

    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public void interceptOutgoingResponse(final RequestDetails theRequestDetails, ResponseDetails theResponseDetails) {
        if (theResponseDetails.getResponseResource() == null) {
            return;
        }
        if (this.isRequestAuthorized(theRequestDetails)) {
            return;
        }
        if (this.isAllowListedRequest(theRequestDetails)) {
            return;
        }
        if (this.isSkipServiceForRequest(theRequestDetails)) {
            return;
        }
        if (this.myConsentService.isEmpty()) {
            return;
        }
        final IdentityHashMap<IBaseResource, ConsentOperationStatusEnum> alreadySeenResources = this.getAlreadySeenResourcesMap(theRequestDetails);
        if (alreadySeenResources.containsKey(theResponseDetails.getResponseResource())) {
            ConsentOperationStatusEnum decisionOnResource = alreadySeenResources.get(theResponseDetails.getResponseResource());
            if (ConsentOperationStatusEnum.AUTHORIZED.equals(decisionOnResource) || ConsentOperationStatusEnum.REJECT.equals(decisionOnResource)) {
                return;
            }
        } else {
            alreadySeenResources.put(theResponseDetails.getResponseResource(), ConsentOperationStatusEnum.PROCEED);
            for (IConsentService next : this.myConsentService) {
                ConsentOutcome outcome = next.willSeeResource(theRequestDetails, theResponseDetails.getResponseResource(), this.myContextConsentServices);
                if (outcome.getResource() != null) {
                    theResponseDetails.setResponseResource(outcome.getResource());
                }
                if (theResponseDetails.getResponseResource() instanceof IBaseBundle) {
                    BundleUtil.setTotal((FhirContext)theRequestDetails.getFhirContext(), (IBaseBundle)((IBaseBundle)theResponseDetails.getResponseResource()), null);
                }
                switch (outcome.getStatus()) {
                    case REJECT: {
                        alreadySeenResources.put(theResponseDetails.getResponseResource(), ConsentOperationStatusEnum.REJECT);
                        if (outcome.getOperationOutcome() != null) {
                            theResponseDetails.setResponseResource((IBaseResource)outcome.getOperationOutcome());
                        } else {
                            theResponseDetails.setResponseResource(null);
                            theResponseDetails.setResponseCode(204);
                        }
                        return;
                    }
                    case AUTHORIZED: {
                        alreadySeenResources.put(theResponseDetails.getResponseResource(), ConsentOperationStatusEnum.AUTHORIZED);
                        return;
                    }
                }
            }
        }
        final IBaseResource outerResource = theResponseDetails.getResponseResource();
        FhirContext ctx = theRequestDetails.getServer().getFhirContext();
        IModelVisitor2 visitor = new IModelVisitor2(){

            public boolean acceptElement(IBase theElement, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                if (theElement instanceof IBaseBundle) {
                    BundleUtil.setTotal((FhirContext)theRequestDetails.getFhirContext(), (IBaseBundle)((IBaseBundle)theElement), null);
                }
                if (theElement == outerResource) {
                    return true;
                }
                if (theElement instanceof IBaseResource) {
                    IBaseResource resource = (IBaseResource)theElement;
                    if (alreadySeenResources.putIfAbsent(resource, ConsentOperationStatusEnum.PROCEED) != null) {
                        return true;
                    }
                    boolean shouldCheckChildren = true;
                    for (IConsentService next : ConsentInterceptor.this.myConsentService) {
                        ConsentOutcome childOutcome = next.willSeeResource(theRequestDetails, resource, ConsentInterceptor.this.myContextConsentServices);
                        IBaseOperationOutcome replacementResource = null;
                        boolean shouldReplaceResource = false;
                        switch (childOutcome.getStatus()) {
                            case REJECT: {
                                replacementResource = childOutcome.getOperationOutcome();
                                shouldReplaceResource = true;
                                alreadySeenResources.put(resource, ConsentOperationStatusEnum.REJECT);
                                break;
                            }
                            case PROCEED: {
                                replacementResource = childOutcome.getResource();
                                shouldReplaceResource = replacementResource != null;
                                break;
                            }
                            case AUTHORIZED: {
                                replacementResource = childOutcome.getResource();
                                shouldReplaceResource = replacementResource != null;
                                shouldCheckChildren = false;
                                alreadySeenResources.put(resource, ConsentOperationStatusEnum.AUTHORIZED);
                            }
                        }
                        if (!shouldReplaceResource) continue;
                        IBase container = theContainingElementPath.get(theContainingElementPath.size() - 2);
                        BaseRuntimeChildDefinition containerChildElement = theChildDefinitionPath.get(theChildDefinitionPath.size() - 1);
                        containerChildElement.getMutator().setValue(container, (IBase)replacementResource);
                        resource = replacementResource;
                    }
                    return shouldCheckChildren;
                }
                return true;
            }

            public boolean acceptUndeclaredExtension(IBaseExtension<?, ?> theNextExt, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                return true;
            }
        };
        ctx.newTerser().visit((IBase)outerResource, visitor);
    }

    @Hook(value=Pointcut.SERVER_HANDLE_EXCEPTION)
    public void requestFailed(RequestDetails theRequest, BaseServerResponseException theException) {
        theRequest.getUserData().put(this.myRequestCompletedKey, Boolean.TRUE);
        for (IConsentService next : this.myConsentService) {
            next.completeOperationFailure(theRequest, theException, this.myContextConsentServices);
        }
    }

    @Hook(value=Pointcut.SERVER_PROCESSING_COMPLETED_NORMALLY)
    public void requestSucceeded(RequestDetails theRequest) {
        if (Boolean.TRUE.equals(theRequest.getUserData().get(this.myRequestCompletedKey))) {
            return;
        }
        for (IConsentService next : this.myConsentService) {
            next.completeOperationSuccess(theRequest, this.myContextConsentServices);
        }
    }

    protected RequestDetails getRequestDetailsForCurrentExportOperation(BulkExportJobParameters theParameters, IBaseResource theBaseResource) {
        SystemRequestDetails details = new SystemRequestDetails();
        return details;
    }

    @Hook(value=Pointcut.STORAGE_BULK_EXPORT_RESOURCE_INCLUSION)
    public boolean shouldBulkExportIncludeResource(BulkExportJobParameters theParameters, IBaseResource theResource) {
        RequestDetails requestDetails = this.getRequestDetailsForCurrentExportOperation(theParameters, theResource);
        for (IConsentService next : this.myConsentService) {
            ConsentOutcome nextOutcome = next.willSeeResource(requestDetails, theResource, this.myContextConsentServices);
            ConsentOperationStatusEnum status = nextOutcome.getStatus();
            switch (status) {
                case PROCEED: 
                case AUTHORIZED: {
                    break;
                }
                case REJECT: {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isRequestAuthorized(RequestDetails theRequestDetails) {
        boolean retVal = false;
        if (theRequestDetails != null) {
            Object authorizedObj = theRequestDetails.getUserData().get(this.myRequestAuthorizedKey);
            retVal = Boolean.TRUE.equals(authorizedObj);
        }
        return retVal;
    }

    private boolean isSkipServiceForRequest(RequestDetails theRequestDetails) {
        return this.isMetadataPath(theRequestDetails) || this.isMetaOperation(theRequestDetails);
    }

    private boolean isAllowListedRequest(RequestDetails theRequestDetails) {
        return this.isMetadataPath(theRequestDetails) || this.isMetaOperation(theRequestDetails);
    }

    private boolean isMetaOperation(RequestDetails theRequestDetails) {
        return theRequestDetails != null && "$meta".equals(theRequestDetails.getOperation());
    }

    private boolean isMetadataPath(RequestDetails theRequestDetails) {
        return theRequestDetails != null && "metadata".equals(theRequestDetails.getRequestPath());
    }

    private void validateParameter(Map<String, String[]> theParameterMap) {
        if (theParameterMap != null) {
            if (theParameterMap.containsKey("_total") && Arrays.stream(theParameterMap.get("_total")).anyMatch("accurate"::equals)) {
                throw new InvalidRequestException(Msg.code((int)2037) + "_total=accurate is not permitted on this server");
            }
            if (theParameterMap.containsKey("_summary") && Arrays.stream(theParameterMap.get("_summary")).anyMatch("count"::equals)) {
                throw new InvalidRequestException(Msg.code((int)2038) + "_summary=count is not permitted on this server");
            }
        }
    }

    private IdentityHashMap<IBaseResource, ConsentOperationStatusEnum> getAlreadySeenResourcesMap(RequestDetails theRequestDetails) {
        IdentityHashMap alreadySeenResources = (IdentityHashMap)theRequestDetails.getUserData().get(this.myRequestSeenResourcesKey);
        if (alreadySeenResources == null) {
            alreadySeenResources = new IdentityHashMap();
            theRequestDetails.getUserData().put(this.myRequestSeenResourcesKey, alreadySeenResources);
        }
        return alreadySeenResources;
    }

    private static ForbiddenOperationException toForbiddenOperationException(ConsentOutcome theOutcome) {
        IBaseOperationOutcome operationOutcome = null;
        if (theOutcome.getOperationOutcome() != null) {
            operationOutcome = theOutcome.getOperationOutcome();
        }
        return new ForbiddenOperationException("Rejected by consent service", operationOutcome);
    }
}

