/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.interceptor.BaseValidatingInterceptor;
import ca.uhn.fhir.rest.server.method.ResourceParameter;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.ValidationResult;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestValidatingInterceptor
extends BaseValidatingInterceptor<String> {
    public static final String DEFAULT_RESPONSE_HEADER_NAME = "X-FHIR-Request-Validation";
    private static final Logger ourLog = LoggerFactory.getLogger(RequestValidatingInterceptor.class);
    private boolean myAddValidationResultsToResponseOperationOutcome = true;

    @Override
    ValidationResult doValidate(FhirValidator theValidator, String theRequest) {
        return theValidator.validateWithResult(theRequest);
    }

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_POST_PROCESSED)
    public boolean incomingRequestPostProcessed(RequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) throws AuthenticationException {
        EncodingEnum encoding = RestfulServerUtils.determineRequestEncodingNoDefault(theRequestDetails);
        if (encoding == null) {
            ourLog.trace("Incoming request does not appear to be FHIR, not going to validate");
            return true;
        }
        Charset charset = ResourceParameter.determineRequestCharset(theRequestDetails);
        String requestText = new String(theRequestDetails.loadRequestContents(), charset);
        if (StringUtils.isBlank((CharSequence)requestText)) {
            ourLog.trace("Incoming request does not have a body");
            return true;
        }
        ValidationResult validationResult = this.validate(requestText, theRequestDetails);
        if (this.myAddValidationResultsToResponseOperationOutcome) {
            RequestValidatingInterceptor.addValidationResultToRequestDetails(theRequestDetails, validationResult);
        }
        return true;
    }

    public boolean isAddValidationResultsToResponseOperationOutcome() {
        return this.myAddValidationResultsToResponseOperationOutcome;
    }

    public void setAddValidationResultsToResponseOperationOutcome(boolean theAddValidationResultsToResponseOperationOutcome) {
        this.myAddValidationResultsToResponseOperationOutcome = theAddValidationResultsToResponseOperationOutcome;
    }

    @Override
    String provideDefaultResponseHeaderName() {
        return DEFAULT_RESPONSE_HEADER_NAME;
    }

    @Override
    public void setResponseHeaderName(String theResponseHeaderName) {
        super.setResponseHeaderName(theResponseHeaderName);
    }
}

