/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server.cdshooks;

import ca.uhn.fhir.rest.api.server.cdshooks.BaseCdsServiceJson;
import ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestAuthorizationJson;
import ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestContextJson;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class CdsServiceRequestJson
extends BaseCdsServiceJson {
    @JsonProperty(value="hook", required=true)
    String myHook;
    @JsonProperty(value="hookInstance", required=true)
    String myHookInstance;
    @JsonProperty(value="fhirServer")
    String myFhirServer;
    @JsonProperty(value="fhirAuthorization")
    CdsServiceRequestAuthorizationJson myServiceRequestAuthorizationJson;
    @JsonProperty(value="context", required=true)
    CdsServiceRequestContextJson myContext;
    @JsonProperty(value="prefetch")
    Map<String, IBaseResource> myPrefetch;

    public String getHookInstance() {
        return this.myHookInstance;
    }

    public CdsServiceRequestJson setHookInstance(String theHookInstance) {
        this.myHookInstance = theHookInstance;
        return this;
    }

    public String getFhirServer() {
        return this.myFhirServer;
    }

    public CdsServiceRequestJson setFhirServer(String theFhirServer) {
        this.myFhirServer = theFhirServer;
        return this;
    }

    public String getHook() {
        return this.myHook;
    }

    public CdsServiceRequestJson setHook(String theHook) {
        this.myHook = theHook;
        return this;
    }

    public CdsServiceRequestContextJson getContext() {
        if (this.myContext == null) {
            this.myContext = new CdsServiceRequestContextJson();
        }
        return this.myContext;
    }

    public CdsServiceRequestJson setContext(CdsServiceRequestContextJson theContext) {
        this.myContext = theContext;
        return this;
    }

    public CdsServiceRequestAuthorizationJson getServiceRequestAuthorizationJson() {
        if (this.myServiceRequestAuthorizationJson == null) {
            this.myServiceRequestAuthorizationJson = new CdsServiceRequestAuthorizationJson();
        }
        return this.myServiceRequestAuthorizationJson;
    }

    public CdsServiceRequestJson setServiceRequestAuthorizationJson(CdsServiceRequestAuthorizationJson theServiceRequestAuthorizationJson) {
        this.myServiceRequestAuthorizationJson = theServiceRequestAuthorizationJson;
        return this;
    }

    public void addPrefetch(String theKey, IBaseResource theResource) {
        if (this.myPrefetch == null) {
            this.myPrefetch = new LinkedHashMap<String, IBaseResource>();
        }
        this.myPrefetch.put(theKey, theResource);
    }

    public IBaseResource getPrefetch(String theKey) {
        if (this.myPrefetch == null) {
            return null;
        }
        return this.myPrefetch.get(theKey);
    }

    public void addContext(String theKey, Object theValue) {
        this.getContext().put(theKey, theValue);
    }

    @Nonnull
    public Set<String> getPrefetchKeys() {
        if (this.myPrefetch == null) {
            return new HashSet<String>();
        }
        return Collections.unmodifiableSet(this.myPrefetch.keySet());
    }
}

