/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.partition;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.IDefaultPartitionSettings;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Interceptor
public class RequestTenantPartitionInterceptor {
    @Autowired
    private PartitionSettings myPartitionSettings;

    public void setPartitionSettings(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    @Hook(value=Pointcut.STORAGE_PARTITION_IDENTIFY_READ)
    public RequestPartitionId partitionIdentifyRead(RequestDetails theRequestDetails, ReadPartitionIdRequestDetails theReadDetails) {
        boolean haveReferences;
        if (this.myPartitionSettings.isAllowUnqualifiedCrossPartitionReference() && theRequestDetails.getRestOperationType() == RestOperationTypeEnum.SEARCH_TYPE && theReadDetails.getSearchParams() != null && (haveReferences = theReadDetails.getSearchParams().entrySet().stream().flatMap(t -> ((List)t.getValue()).stream()).flatMap(Collection::stream).filter(t -> t instanceof ReferenceParam).map(t -> (ReferenceParam)t).anyMatch(t -> t.getChain() == null))) {
            return RequestPartitionId.allPartitions();
        }
        return this.extractPartitionIdFromRequest(theRequestDetails);
    }

    @Hook(value=Pointcut.STORAGE_PARTITION_IDENTIFY_CREATE)
    public RequestPartitionId partitionIdentifyCreate(RequestDetails theRequestDetails) {
        return this.extractPartitionIdFromRequest(theRequestDetails);
    }

    @Nonnull
    protected RequestPartitionId extractPartitionIdFromRequest(RequestDetails theRequestDetails) {
        String tenantId = theRequestDetails.getTenantId();
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            if (theRequestDetails instanceof SystemRequestDetails) {
                SystemRequestDetails requestDetails = (SystemRequestDetails)theRequestDetails;
                if (requestDetails.getRequestPartitionId() != null) {
                    return requestDetails.getRequestPartitionId();
                }
                return RequestPartitionId.defaultPartition((IDefaultPartitionSettings)this.myPartitionSettings);
            }
            throw new InternalErrorException(Msg.code((int)343) + "No partition ID has been specified");
        }
        if (tenantId.equals("_ALL")) {
            return RequestPartitionId.allPartitions();
        }
        return RequestPartitionId.fromPartitionName((String)tenantId);
    }
}

