/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.util;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.param.CompositeAndListParam;
import ca.uhn.fhir.rest.param.DateAndListParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.HasParam;
import ca.uhn.fhir.rest.param.NumberAndListParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityAndListParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.SpecialAndListParam;
import ca.uhn.fhir.rest.param.SpecialParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.param.binder.QueryParameterAndBinder;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class JpaParamUtil
extends Enum<JpaParamUtil> {
    private static final /* synthetic */ JpaParamUtil[] $VALUES;

    public static JpaParamUtil[] values() {
        return (JpaParamUtil[])$VALUES.clone();
    }

    public static JpaParamUtil valueOf(String name) {
        return Enum.valueOf(JpaParamUtil.class, name);
    }

    public static IQueryParameterAnd<?> parseQueryParams(FhirContext theContext, RestSearchParameterTypeEnum paramType, String theUnqualifiedParamName, List<QualifiedParamList> theParameters) {
        return (switch (paramType) {
            case RestSearchParameterTypeEnum.COMPOSITE -> throw new UnsupportedOperationException(Msg.code((int)496));
            case RestSearchParameterTypeEnum.DATE -> new QueryParameterAndBinder(DateAndListParam.class, Collections.emptyList());
            case RestSearchParameterTypeEnum.NUMBER -> new QueryParameterAndBinder(NumberAndListParam.class, Collections.emptyList());
            case RestSearchParameterTypeEnum.QUANTITY -> new QueryParameterAndBinder(QuantityAndListParam.class, Collections.emptyList());
            case RestSearchParameterTypeEnum.REFERENCE -> new QueryParameterAndBinder(ReferenceAndListParam.class, Collections.emptyList());
            case RestSearchParameterTypeEnum.STRING -> new QueryParameterAndBinder(StringAndListParam.class, Collections.emptyList());
            case RestSearchParameterTypeEnum.TOKEN -> new QueryParameterAndBinder(TokenAndListParam.class, Collections.emptyList());
            case RestSearchParameterTypeEnum.URI -> new QueryParameterAndBinder(UriAndListParam.class, Collections.emptyList());
            case RestSearchParameterTypeEnum.HAS -> new QueryParameterAndBinder(HasAndListParam.class, Collections.emptyList());
            case RestSearchParameterTypeEnum.SPECIAL -> new QueryParameterAndBinder(SpecialAndListParam.class, Collections.emptyList());
            default -> throw new IllegalArgumentException(Msg.code((int)497) + "Parameter '" + theUnqualifiedParamName + "' has type " + String.valueOf(paramType) + " which is currently not supported.");
        }).parse(theContext, theUnqualifiedParamName, theParameters);
    }

    public static IQueryParameterAnd<?> parseQueryParams(ISearchParamRegistry theSearchParamRegistry, FhirContext theContext, RuntimeSearchParam theParamDef, String theUnqualifiedParamName, List<QualifiedParamList> theParameters) {
        RestSearchParameterTypeEnum paramType = theParamDef.getParamType();
        if (paramType == RestSearchParameterTypeEnum.COMPOSITE) {
            List<ComponentAndCorrespondingParam> compositeList = JpaParamUtil.resolveCompositeComponents(theSearchParamRegistry, theParamDef);
            if (compositeList.size() != 2) {
                throw new ConfigurationException(Msg.code((int)498) + "Search parameter of type " + theUnqualifiedParamName + " must have 2 composite types declared in parameter annotation, found " + compositeList.size());
            }
            RuntimeSearchParam left = compositeList.get(0).getComponentParameter();
            RuntimeSearchParam right = compositeList.get(1).getComponentParameter();
            CompositeAndListParam cp = new CompositeAndListParam(JpaParamUtil.getCompositeBindingClass(left.getParamType(), left.getName()), JpaParamUtil.getCompositeBindingClass(right.getParamType(), right.getName()));
            cp.setValuesAsQueryTokens(theContext, theUnqualifiedParamName, theParameters);
            return cp;
        }
        return JpaParamUtil.parseQueryParams(theContext, paramType, theUnqualifiedParamName, theParameters);
    }

    @Nonnull
    public static List<ComponentAndCorrespondingParam> resolveCompositeComponents(ISearchParamRegistry theSearchParamRegistry, RuntimeSearchParam theCompositeParameter) {
        ArrayList<ComponentAndCorrespondingParam> compositeList = new ArrayList<ComponentAndCorrespondingParam>();
        List components = theCompositeParameter.getComponents();
        for (RuntimeSearchParam.Component next : components) {
            String url = next.getReference();
            RuntimeSearchParam componentParam = theSearchParamRegistry.getActiveSearchParamByUrl(url, ISearchParamRegistry.SearchParamLookupContextEnum.ALL);
            if (componentParam == null) {
                throw new InternalErrorException(Msg.code((int)499) + "Can not find SearchParameter: " + url);
            }
            compositeList.add(new ComponentAndCorrespondingParam(next, componentParam));
        }
        return compositeList;
    }

    private static Class<?> getCompositeBindingClass(RestSearchParameterTypeEnum paramType, String theUnqualifiedParamName) {
        switch (paramType) {
            case DATE: {
                return DateParam.class;
            }
            case NUMBER: {
                return NumberParam.class;
            }
            case QUANTITY: {
                return QuantityParam.class;
            }
            case REFERENCE: {
                return ReferenceParam.class;
            }
            case STRING: {
                return StringParam.class;
            }
            case TOKEN: {
                return TokenParam.class;
            }
            case URI: {
                return UriParam.class;
            }
            case HAS: {
                return HasParam.class;
            }
            case SPECIAL: {
                return SpecialParam.class;
            }
        }
        throw new IllegalArgumentException(Msg.code((int)500) + "Parameter '" + theUnqualifiedParamName + "' has type " + String.valueOf(paramType) + " which is currently not supported.");
    }

    public static RestSearchParameterTypeEnum getParameterTypeForComposite(ISearchParamRegistry theSearchParamRegistry, ComponentAndCorrespondingParam theComponentAndParam) {
        String chain = theComponentAndParam.getComponent().getComboUpliftChain();
        if (chain != null) {
            RuntimeSearchParam targetParameter = theComponentAndParam.getComponentParameter();
            for (String target : targetParameter.getTargets()) {
                RuntimeSearchParam chainTargetParam = theSearchParamRegistry.getActiveSearchParam(target, chain, ISearchParamRegistry.SearchParamLookupContextEnum.ALL);
                if (chainTargetParam == null) continue;
                return chainTargetParam.getParamType();
            }
            return RestSearchParameterTypeEnum.TOKEN;
        }
        return theComponentAndParam.getComponentParameter().getParamType();
    }

    private static /* synthetic */ JpaParamUtil[] $values() {
        return new JpaParamUtil[0];
    }

    static {
        $VALUES = JpaParamUtil.$values();
    }

    public static class ComponentAndCorrespondingParam {
        private final String myCombinedParamName;
        private final RuntimeSearchParam.Component myComponent;
        private final RuntimeSearchParam myComponentParameter;
        private final String myParamName;
        private final String myChain;

        ComponentAndCorrespondingParam(@Nonnull RuntimeSearchParam.Component theComponent, @Nonnull RuntimeSearchParam theComponentParameter) {
            this.myComponent = theComponent;
            this.myComponentParameter = theComponentParameter;
            int dotIdx = theComponentParameter.getName().indexOf(".");
            if (dotIdx != -1) {
                this.myParamName = theComponentParameter.getName().substring(0, dotIdx);
                this.myChain = theComponentParameter.getName().substring(dotIdx + 1);
                this.myCombinedParamName = theComponentParameter.getName();
            } else {
                this.myParamName = theComponentParameter.getName();
                this.myChain = theComponent.getComboUpliftChain();
                this.myCombinedParamName = this.myChain != null ? this.myParamName + "." + this.myChain : this.myParamName;
            }
        }

        @Nonnull
        public RuntimeSearchParam.Component getComponent() {
            return this.myComponent;
        }

        @Nonnull
        public RuntimeSearchParam getComponentParameter() {
            return this.myComponentParameter;
        }

        @Nonnull
        public String getParamName() {
            return this.myParamName;
        }

        @Nullable
        public String getChain() {
            return this.myChain;
        }

        @Nonnull
        public String getCombinedParamName() {
            return this.myCombinedParamName;
        }
    }
}

