/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.retry;

import ca.uhn.fhir.system.HapiSystemProperties;
import java.util.function.Supplier;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

public class Retrier<T> {
    private static final Logger ourLog = LoggerFactory.getLogger(Retrier.class);
    private final Supplier<T> mySupplier;
    private final RetryTemplate myRetryTemplate;

    public Retrier(Supplier<T> theSupplier, final int theMaxRetries) {
        Validate.isTrue((theMaxRetries > 0 ? 1 : 0) != 0, (String)"maxRetries must be above zero.", (Object[])new Object[0]);
        this.mySupplier = theSupplier;
        this.myRetryTemplate = new RetryTemplate();
        ExponentialBackOffPolicy backOff = new ExponentialBackOffPolicy();
        backOff.setInitialInterval(500L);
        backOff.setMaxInterval(60000L);
        backOff.setMultiplier(2.0);
        this.myRetryTemplate.setBackOffPolicy((BackOffPolicy)backOff);
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(){
            private static final long serialVersionUID = -4522467251787518700L;

            public boolean canRetry(RetryContext context) {
                Throwable lastThrowable = context.getLastThrowable();
                if (lastThrowable instanceof BeanCreationException || lastThrowable instanceof NullPointerException) {
                    return false;
                }
                return super.canRetry(context);
            }
        };
        retryPolicy.setMaxAttempts(theMaxRetries);
        this.myRetryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        RetryListener listener = new RetryListener(){

            public <TT, E extends Throwable> void onError(RetryContext context, RetryCallback<TT, E> callback, Throwable throwable) {
                if (throwable instanceof NullPointerException || throwable instanceof UnsupportedOperationException || HapiSystemProperties.isUnitTestModeEnabled() || context.getRetryCount() == 1) {
                    ourLog.error("Retry failure {}/{}: {}", new Object[]{context.getRetryCount(), theMaxRetries, throwable.getMessage(), throwable});
                } else {
                    ourLog.error("Retry failure {}/{}: {}", new Object[]{context.getRetryCount(), theMaxRetries, throwable.toString()});
                }
            }
        };
        this.myRetryTemplate.registerListener(listener);
    }

    public T runWithRetry() {
        return (T)this.myRetryTemplate.execute(retryContext -> this.mySupplier.get());
    }
}

