/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.registry;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.searchparam.registry.RuntimeSearchParamCache;
import ca.uhn.fhir.jpa.searchparam.registry.SearchParameterCanonicalizer;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ReadOnlySearchParamCache {
    protected final Map<String, ResourceSearchParams> myResourceNameToSpNameToSp;
    protected final Map<String, RuntimeSearchParam> myUrlToParam;

    ReadOnlySearchParamCache() {
        this.myResourceNameToSpNameToSp = new HashMap<String, ResourceSearchParams>();
        this.myUrlToParam = new HashMap<String, RuntimeSearchParam>();
    }

    private ReadOnlySearchParamCache(RuntimeSearchParamCache theRuntimeSearchParamCache) {
        this.myResourceNameToSpNameToSp = theRuntimeSearchParamCache.myResourceNameToSpNameToSp;
        this.myUrlToParam = theRuntimeSearchParamCache.myUrlToParam;
    }

    public Stream<RuntimeSearchParam> getSearchParamStream() {
        return this.myResourceNameToSpNameToSp.values().stream().flatMap(entry -> entry.values().stream());
    }

    protected ResourceSearchParams getSearchParamMap(String theResourceName) {
        ResourceSearchParams retval = this.myResourceNameToSpNameToSp.get(theResourceName);
        if (retval == null) {
            return ResourceSearchParams.empty((String)theResourceName);
        }
        return retval.readOnly();
    }

    public int size() {
        return this.myResourceNameToSpNameToSp.size();
    }

    @Nullable
    public RuntimeSearchParam getByUrl(String theUrl) {
        return this.myUrlToParam.get(theUrl);
    }

    public static ReadOnlySearchParamCache fromFhirContext(@Nonnull FhirContext theFhirContext, @Nonnull SearchParameterCanonicalizer theCanonicalizer) {
        return ReadOnlySearchParamCache.fromFhirContext(theFhirContext, theCanonicalizer, null);
    }

    public static ReadOnlySearchParamCache fromFhirContext(@Nonnull FhirContext theFhirContext, @Nonnull SearchParameterCanonicalizer theCanonicalizer, @Nullable Set<String> theSearchParamPatternsToInclude) {
        String nextParamName;
        assert (theCanonicalizer != null);
        ReadOnlySearchParamCache retVal = new ReadOnlySearchParamCache();
        Set resourceNames = theFhirContext.getResourceTypes();
        FhirContext cachedCtx = FhirContext.forCached((FhirVersionEnum)theFhirContext.getVersion().getVersion());
        List searchParams = cachedCtx.getValidationSupport().fetchAllSearchParameters();
        searchParams = (List)ObjectUtils.defaultIfNull((Object)searchParams, Collections.emptyList());
        for (IBaseResource next : searchParams) {
            RuntimeSearchParam nextCanonical = theCanonicalizer.canonicalizeSearchParameter(next);
            if (nextCanonical == null) continue;
            Set base = (nextCanonical = new RuntimeSearchParam(nextCanonical.getId(), nextCanonical.getUri(), nextCanonical.getName(), nextCanonical.getDescription(), nextCanonical.getPath(), nextCanonical.getParamType(), nextCanonical.getProvidesMembershipInCompartments(), nextCanonical.getTargets(), RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE, nextCanonical.getComboSearchParamType(), nextCanonical.getComponents(), (Collection)nextCanonical.getBase())).getBase();
            if (base.contains("Resource") || base.contains("DomainResource")) {
                base = resourceNames;
            }
            for (String nextResourceName : base) {
                ResourceSearchParams resourceSearchParams = retVal.myResourceNameToSpNameToSp.computeIfAbsent(nextResourceName, t -> new ResourceSearchParams(nextResourceName));
                nextParamName = nextCanonical.getName();
                if (theSearchParamPatternsToInclude != null && !ReadOnlySearchParamCache.searchParamMatchesAtLeastOnePattern(theSearchParamPatternsToInclude, nextResourceName, nextParamName)) continue;
                resourceSearchParams.addSearchParamIfAbsent(nextParamName, nextCanonical);
            }
        }
        for (String resourceName : resourceNames) {
            RuntimeResourceDefinition nextResDef = theFhirContext.getResourceDefinition(resourceName);
            String nextResourceName = nextResDef.getName();
            ResourceSearchParams resourceSearchParams = retVal.myResourceNameToSpNameToSp.computeIfAbsent(nextResourceName, t -> new ResourceSearchParams(nextResourceName));
            for (RuntimeSearchParam nextSp : nextResDef.getSearchParams()) {
                nextParamName = nextSp.getName();
                if (theSearchParamPatternsToInclude != null && !ReadOnlySearchParamCache.searchParamMatchesAtLeastOnePattern(theSearchParamPatternsToInclude, nextResourceName, nextParamName)) continue;
                resourceSearchParams.addSearchParamIfAbsent(nextParamName, nextSp);
            }
        }
        return retVal;
    }

    public static boolean searchParamMatchesAtLeastOnePattern(Set<String> theSearchParamPatterns, String theResourceType, String theSearchParamName) {
        for (String nextPattern : theSearchParamPatterns) {
            if ("*".equals(nextPattern)) {
                return true;
            }
            int colonIdx = nextPattern.indexOf(58);
            Validate.isTrue((colonIdx > 0 ? 1 : 0) != 0, (String)"Invalid search param pattern: %s", (Object[])new Object[]{nextPattern});
            String resourceType = nextPattern.substring(0, colonIdx);
            String searchParamName = nextPattern.substring(colonIdx + 1);
            Validate.notBlank((CharSequence)resourceType, (String)"No resource type specified in pattern: %s", (Object[])new Object[]{nextPattern});
            Validate.notBlank((CharSequence)searchParamName, (String)"No param name specified in pattern: %s", (Object[])new Object[]{nextPattern});
            if (!resourceType.equals("*") && !resourceType.equals(theResourceType) || !searchParamName.equals("*") && !searchParamName.equals(theSearchParamName)) continue;
            return true;
        }
        return false;
    }

    public static ReadOnlySearchParamCache fromRuntimeSearchParamCache(RuntimeSearchParamCache theRuntimeSearchParamCache) {
        return new ReadOnlySearchParamCache(theRuntimeSearchParamCache);
    }
}

