/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.registry;

import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.phonetic.IPhoneticEncoder;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.model.util.SearchParamHash;
import ca.uhn.fhir.jpa.searchparam.registry.RuntimeSearchParamCache;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.IndexedSearchParam;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaSearchParamCache {
    private static final Logger ourLog = LoggerFactory.getLogger(JpaSearchParamCache.class);
    private static final List<RestSearchParameterTypeEnum> SUPPORTED_INDEXED_SEARCH_PARAMS = List.of(RestSearchParameterTypeEnum.SPECIAL, RestSearchParameterTypeEnum.DATE, RestSearchParameterTypeEnum.NUMBER, RestSearchParameterTypeEnum.QUANTITY, RestSearchParameterTypeEnum.STRING, RestSearchParameterTypeEnum.TOKEN, RestSearchParameterTypeEnum.URI, RestSearchParameterTypeEnum.REFERENCE);
    volatile Map<String, List<RuntimeSearchParam>> myActiveComboSearchParams = Collections.emptyMap();
    volatile Map<String, Map<Set<String>, List<RuntimeSearchParam>>> myActiveParamNamesToComboSearchParams = Collections.emptyMap();
    volatile Map<Long, IndexedSearchParam> myHashIdentityToIndexedSearchParams = Collections.emptyMap();
    private final PartitionSettings myPartitionSettings;

    public JpaSearchParamCache(@Nonnull PartitionSettings thePartitionSettings) {
        assert (thePartitionSettings != null);
        this.myPartitionSettings = thePartitionSettings;
    }

    public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName) {
        List<Object> retval = this.myActiveComboSearchParams.get(theResourceName);
        if (retval == null) {
            retval = Collections.emptyList();
        }
        return retval;
    }

    public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName, ComboSearchParamType theParamType) {
        List<RuntimeSearchParam> activeComboSearchParams = this.getActiveComboSearchParams(theResourceName);
        List<RuntimeSearchParam> retVal = activeComboSearchParams.stream().filter(param -> Objects.equals(theParamType, param.getComboSearchParamType())).collect(Collectors.toList());
        return retVal;
    }

    public Optional<RuntimeSearchParam> getActiveComboSearchParamById(String theResourceName, IIdType theId) {
        IIdType idToFind = theId.toUnqualifiedVersionless();
        return this.getActiveComboSearchParams(theResourceName).stream().filter(param -> Objects.equals(idToFind, param.getIdUnqualifiedVersionless())).findFirst();
    }

    public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName, Set<String> theParamNames) {
        Map<Set<String>, List<RuntimeSearchParam>> paramNamesToParams = this.myActiveParamNamesToComboSearchParams.get(theResourceName);
        if (paramNamesToParams == null) {
            return Collections.emptyList();
        }
        List<Object> retVal = paramNamesToParams.get(theParamNames);
        if (retVal == null) {
            retVal = Collections.emptyList();
        }
        return Collections.unmodifiableList(retVal);
    }

    public Map<Long, IndexedSearchParam> getHashIdentityToIndexedSearchParamMap() {
        return this.myHashIdentityToIndexedSearchParams;
    }

    void populateActiveSearchParams(IInterceptorService theInterceptorBroadcaster, IPhoneticEncoder theDefaultPhoneticEncoder, RuntimeSearchParamCache theActiveSearchParams) {
        HashMap<String, List<RuntimeSearchParam>> resourceNameToComboSearchParams = new HashMap<String, List<RuntimeSearchParam>>();
        HashMap<String, Map<Set<String>, List<RuntimeSearchParam>>> activeParamNamesToComboSearchParams = new HashMap<String, Map<Set<String>, List<RuntimeSearchParam>>>();
        HashMap<String, RuntimeSearchParam> idToRuntimeSearchParam = new HashMap<String, RuntimeSearchParam>();
        ArrayList<RuntimeSearchParam> jpaSearchParams = new ArrayList<RuntimeSearchParam>();
        HashMap<Long, IndexedSearchParam> hashIdentityToIndexedSearchParams = new HashMap<Long, IndexedSearchParam>();
        for (String theResourceName : theActiveSearchParams.getResourceNameKeys()) {
            ResourceSearchParams searchParams = theActiveSearchParams.getSearchParamMap(theResourceName);
            List comboSearchParams = resourceNameToComboSearchParams.computeIfAbsent(theResourceName, k -> new ArrayList());
            Collection nextSearchParamsForResourceName = searchParams.values();
            ourLog.trace("Resource {} has {} params", (Object)theResourceName, (Object)searchParams.size());
            for (RuntimeSearchParam nextCandidate : nextSearchParamsForResourceName) {
                ourLog.trace("Resource {} has parameter {} with ID {}", new Object[]{theResourceName, nextCandidate.getName(), nextCandidate.getId()});
                if (nextCandidate.getId() != null) {
                    idToRuntimeSearchParam.put(nextCandidate.getId().toUnqualifiedVersionless().getValue(), nextCandidate);
                }
                if (StringUtils.isNotBlank((CharSequence)nextCandidate.getUri())) {
                    idToRuntimeSearchParam.put(nextCandidate.getUri(), nextCandidate);
                }
                jpaSearchParams.add(nextCandidate);
                if (nextCandidate.getComboSearchParamType() != null) {
                    comboSearchParams.add(nextCandidate);
                }
                this.setPhoneticEncoder(theDefaultPhoneticEncoder, nextCandidate);
                this.populateIndexedSearchParams(theResourceName, nextCandidate, hashIdentityToIndexedSearchParams);
            }
        }
        ourLog.trace("Have {} search params loaded", (Object)idToRuntimeSearchParam.size());
        HashSet<String> haveSeen = new HashSet<String>();
        for (RuntimeSearchParam next : jpaSearchParams) {
            if (next.getId() != null && !haveSeen.add(next.getId().toUnqualifiedVersionless().getValue())) continue;
            TreeSet<String> paramNames = new TreeSet<String>();
            for (RuntimeSearchParam.Component nextComponent : next.getComponents()) {
                String nextRef = nextComponent.getReference();
                RuntimeSearchParam componentTarget = (RuntimeSearchParam)idToRuntimeSearchParam.get(nextRef);
                if (componentTarget != null) {
                    paramNames.add(componentTarget.getName());
                    continue;
                }
                String message = "Search parameter " + String.valueOf(next) + " refers to unknown component " + nextRef + ", ignoring this parameter";
                ourLog.warn(message);
                HookParams params = new HookParams().add(RequestDetails.class, null).add(ServletRequestDetails.class, null).add(StorageProcessingMessage.class, (Object)new StorageProcessingMessage().setMessage(message));
                theInterceptorBroadcaster.callHooks((IPointcut)Pointcut.JPA_PERFTRACE_WARNING, params);
            }
            if (next.getComboSearchParamType() == null) continue;
            for (String nextBase : next.getBase()) {
                activeParamNamesToComboSearchParams.computeIfAbsent(nextBase, v -> new HashMap());
                ((Map)activeParamNamesToComboSearchParams.get(nextBase)).computeIfAbsent(paramNames, t -> new ArrayList());
                ((List)((Map)activeParamNamesToComboSearchParams.get(nextBase)).get(paramNames)).add(next);
            }
        }
        ourLog.debug("Have {} unique search params", (Object)activeParamNamesToComboSearchParams.size());
        this.myActiveComboSearchParams = resourceNameToComboSearchParams;
        this.myActiveParamNamesToComboSearchParams = activeParamNamesToComboSearchParams;
        this.myHashIdentityToIndexedSearchParams = hashIdentityToIndexedSearchParams;
    }

    void setPhoneticEncoder(IPhoneticEncoder theDefaultPhoneticEncoder, RuntimeSearchParam searchParam) {
        if ("phonetic".equals(searchParam.getName())) {
            ourLog.debug("Setting search param {} on {} phonetic encoder to {}", new Object[]{searchParam.getName(), searchParam.getPath(), theDefaultPhoneticEncoder == null ? "null" : theDefaultPhoneticEncoder.name()});
            searchParam.setPhoneticEncoder(theDefaultPhoneticEncoder);
        }
    }

    private void populateIndexedSearchParams(String theResourceName, RuntimeSearchParam theRuntimeSearchParam, Map<Long, IndexedSearchParam> theHashIdentityToIndexedSearchParams) {
        if (SUPPORTED_INDEXED_SEARCH_PARAMS.contains(theRuntimeSearchParam.getParamType())) {
            this.addIndexedSearchParam(theResourceName, theHashIdentityToIndexedSearchParams, theRuntimeSearchParam.getName());
            if (theRuntimeSearchParam.getParamType() == RestSearchParameterTypeEnum.TOKEN) {
                this.addIndexedSearchParam(theResourceName, theHashIdentityToIndexedSearchParams, theRuntimeSearchParam.getName() + ":of-type");
            }
            theRuntimeSearchParam.getUpliftRefchainCodes().stream().map(urCode -> theRuntimeSearchParam.getName() + "." + urCode).forEach(urSpName -> this.addIndexedSearchParam(theResourceName, theHashIdentityToIndexedSearchParams, (String)urSpName));
        }
    }

    private void addIndexedSearchParam(String theResourceName, Map<Long, IndexedSearchParam> theHashIdentityToIndexedSearchParams, String theSpName) {
        Long hashIdentity = SearchParamHash.hashSearchParam((PartitionSettings)this.myPartitionSettings, (RequestPartitionId)RequestPartitionId.defaultPartition(), (String[])new String[]{theResourceName, theSpName});
        theHashIdentityToIndexedSearchParams.put(hashIdentity, new IndexedSearchParam(theSpName, theResourceName));
    }
}

