/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.matcher;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryResourceMatcher;
import ca.uhn.fhir.jpa.searchparam.matcher.IndexedSearchParamExtractor;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchParamMatcher {
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private IndexedSearchParamExtractor myIndexedSearchParamExtractor;
    @Autowired
    private InMemoryResourceMatcher myInMemoryResourceMatcher;

    public InMemoryMatchResult match(String theCriteria, IBaseResource theResource, RequestDetails theRequest) {
        return this.myInMemoryResourceMatcher.match(theCriteria, theResource, null, theRequest);
    }

    public InMemoryMatchResult match(SearchParameterMap theSearchParameterMap, IBaseResource theResource) {
        if (theSearchParameterMap.isEmpty()) {
            return InMemoryMatchResult.successfulMatch();
        }
        ResourceIndexedSearchParams resourceIndexedSearchParams = this.myIndexedSearchParamExtractor.extractIndexedSearchParams(theResource, null, this.getFilter(theSearchParameterMap));
        RuntimeResourceDefinition resourceDefinition = this.myFhirContext.getResourceDefinition(theResource);
        return this.myInMemoryResourceMatcher.match(theSearchParameterMap, theResource, resourceDefinition, resourceIndexedSearchParams);
    }

    private ISearchParamExtractor.ISearchParamFilter getFilter(SearchParameterMap searchParameterMap) {
        return theSearchParams -> theSearchParams.stream().filter(runtimeSearchParam -> searchParameterMap.keySet().contains(runtimeSearchParam.getName())).collect(Collectors.toList());
    }
}

