/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.matcher;

import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.SearchParamMatcher;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthorizationSearchParamMatcher;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationSearchParamMatcher
implements IAuthorizationSearchParamMatcher {
    private static final Logger ourLog = LoggerFactory.getLogger(AuthorizationSearchParamMatcher.class);
    private final SearchParamMatcher mySearchParamMatcher;

    public AuthorizationSearchParamMatcher(SearchParamMatcher mySearchParamMatcher) {
        this.mySearchParamMatcher = mySearchParamMatcher;
    }

    public IAuthorizationSearchParamMatcher.MatchResult match(String theQueryParameters, IBaseResource theResource) {
        try {
            InMemoryMatchResult inMemoryMatchResult = this.mySearchParamMatcher.match(theQueryParameters, theResource, null);
            if (!inMemoryMatchResult.supported()) {
                return IAuthorizationSearchParamMatcher.MatchResult.buildUnsupported((String)inMemoryMatchResult.getUnsupportedReason());
            }
            if (inMemoryMatchResult.matched()) {
                return IAuthorizationSearchParamMatcher.MatchResult.buildMatched();
            }
            return IAuthorizationSearchParamMatcher.MatchResult.buildUnmatched();
        }
        catch (MatchUrlService.UnrecognizedSearchParameterException e) {
            ourLog.info("Unsupported filter {} applied to resource: {}", (Object)theQueryParameters, (Object)e.getMessage());
            return IAuthorizationSearchParamMatcher.MatchResult.buildUnsupported((String)e.getMessage());
        }
    }
}

