/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.extractor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.sl.cache.Cache;
import ca.uhn.fhir.sl.cache.CacheFactory;
import ca.uhn.fhir.util.BundleUtil;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.r5.fhirpath.IHostApplicationServices;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.fhirpath.FHIRPathConstantEvaluationMode;

public class SearchParamExtractorR5
extends BaseSearchParamExtractor
implements ISearchParamExtractor {
    private FHIRPathEngine myFhirPathEngine;
    private Cache<String, ExpressionNode> myParsedFhirPathCache;

    public SearchParamExtractorR5() {
    }

    public SearchParamExtractorR5(StorageSettings theStorageSettings, PartitionSettings thePartitionSettings, FhirContext theCtx, ISearchParamRegistry theSearchParamRegistry) {
        super(theStorageSettings, thePartitionSettings, theCtx, theSearchParamRegistry);
        this.initFhirPath();
        this.start();
    }

    @Override
    @PostConstruct
    public void start() {
        super.start();
        if (this.myFhirPathEngine == null) {
            this.initFhirPath();
        }
    }

    public void initFhirPath() {
        HapiWorkerContext worker = new HapiWorkerContext(this.getContext(), this.getContext().getValidationSupport());
        this.myFhirPathEngine = new FHIRPathEngine((IWorkerContext)worker);
        this.myFhirPathEngine.setHostServices((IHostApplicationServices)new SearchParamExtractorR5HostServices());
        this.myParsedFhirPathCache = CacheFactory.build((long)TimeUnit.MINUTES.toMillis(10L));
    }

    @Override
    public BaseSearchParamExtractor.IValueExtractor getPathValueExtractor(IBase theResource, String theSinglePath) {
        return () -> {
            ExpressionNode parsed = (ExpressionNode)this.myParsedFhirPathCache.get((Object)theSinglePath, path -> this.myFhirPathEngine.parse(path));
            return this.myFhirPathEngine.evaluate((Object)theResource, (Base)theResource, (Base)theResource, (Base)theResource, parsed);
        };
    }

    private class SearchParamExtractorR5HostServices
    implements IHostApplicationServices {
        private final Map<String, Base> myResourceTypeToStub = Collections.synchronizedMap(new HashMap());

        private SearchParamExtractorR5HostServices() {
        }

        public List<Base> resolveConstant(FHIRPathEngine engine, Object appContext, String name, FHIRPathConstantEvaluationMode mode) throws PathEngineException {
            return Collections.emptyList();
        }

        public TypeDetails resolveConstantType(FHIRPathEngine engine, Object appContext, String name, FHIRPathConstantEvaluationMode mode) throws PathEngineException {
            return null;
        }

        public boolean log(String argument, List<Base> focus) {
            return false;
        }

        public FHIRPathUtilityClasses.FunctionDetails resolveFunction(FHIRPathEngine engine, String functionName) {
            return null;
        }

        public TypeDetails checkFunction(FHIRPathEngine engine, Object appContext, String functionName, TypeDetails focus, List<TypeDetails> parameters) throws PathEngineException {
            return null;
        }

        public List<Base> executeFunction(FHIRPathEngine engine, Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
            return null;
        }

        public Base resolveReference(FHIRPathEngine engine, Object appContext, String theUrl, Base refContext) {
            Object retVal = (Base)BundleUtil.getReferenceInBundle((FhirContext)SearchParamExtractorR5.this.getContext(), (String)theUrl, (Object)appContext);
            if (retVal != null) {
                return retVal;
            }
            final IdType url = new IdType(theUrl);
            if (StringUtils.isNotBlank((CharSequence)url.getResourceType())) {
                retVal = this.myResourceTypeToStub.get(url.getResourceType());
                if (retVal != null) {
                    return retVal;
                }
                final ResourceType resourceType = ResourceType.fromCode((String)url.getResourceType());
                if (resourceType != null) {
                    retVal = new Resource(){
                        private static final long serialVersionUID = 2368522971330181178L;

                        public Resource copy() {
                            return this;
                        }

                        public ResourceType getResourceType() {
                            return resourceType;
                        }

                        public String fhirType() {
                            return url.getResourceType();
                        }
                    };
                    this.myResourceTypeToStub.put(url.getResourceType(), (Base)retVal);
                }
            }
            return retVal;
        }

        public boolean conformsToProfile(FHIRPathEngine engine, Object appContext, Base item, String url) throws FHIRException {
            return false;
        }

        public ValueSet resolveValueSet(FHIRPathEngine engine, Object appContext, String url) {
            return null;
        }

        public boolean paramIsType(String name, int index) {
            return false;
        }
    }
}

