/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.extractor;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboStringUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboTokenNonUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamNumber;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantityNormalized;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.PathAndRef;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParamComposite;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;

public interface ISearchParamExtractor {
    public static final ISearchParamFilter ALL_PARAMS = t -> t;
    public static final ISearchParamFilter NO_PARAMS = t -> Collections.emptyList();

    default public SearchParamSet<ResourceIndexedSearchParamDate> extractSearchParamDates(IBaseResource theResource) {
        return this.extractSearchParamDates(theResource, ALL_PARAMS);
    }

    public SearchParamSet<ResourceIndexedSearchParamDate> extractSearchParamDates(IBaseResource var1, ISearchParamFilter var2);

    default public SearchParamSet<ResourceIndexedSearchParamNumber> extractSearchParamNumber(IBaseResource theResource) {
        return this.extractSearchParamNumber(theResource, ALL_PARAMS);
    }

    public SearchParamSet<ResourceIndexedSearchParamNumber> extractSearchParamNumber(IBaseResource var1, ISearchParamFilter var2);

    default public SearchParamSet<ResourceIndexedSearchParamQuantity> extractSearchParamQuantity(IBaseResource theResource) {
        return this.extractSearchParamQuantity(theResource, ALL_PARAMS);
    }

    public SearchParamSet<ResourceIndexedSearchParamQuantity> extractSearchParamQuantity(IBaseResource var1, ISearchParamFilter var2);

    default public SearchParamSet<ResourceIndexedSearchParamQuantityNormalized> extractSearchParamQuantityNormalized(IBaseResource theResource) {
        return this.extractSearchParamQuantityNormalized(theResource, ALL_PARAMS);
    }

    public SearchParamSet<ResourceIndexedSearchParamQuantityNormalized> extractSearchParamQuantityNormalized(IBaseResource var1, ISearchParamFilter var2);

    default public SearchParamSet<ResourceIndexedSearchParamString> extractSearchParamStrings(IBaseResource theResource) {
        return this.extractSearchParamStrings(theResource, ALL_PARAMS);
    }

    public SearchParamSet<ResourceIndexedSearchParamString> extractSearchParamStrings(IBaseResource var1, ISearchParamFilter var2);

    default public SearchParamSet<ResourceIndexedSearchParamComposite> extractSearchParamComposites(IBaseResource theResource) {
        return this.extractSearchParamComposites(theResource, ALL_PARAMS);
    }

    public SearchParamSet<ResourceIndexedSearchParamComposite> extractSearchParamComposites(IBaseResource var1, ISearchParamFilter var2);

    default public SearchParamSet<BaseResourceIndexedSearchParam> extractSearchParamTokens(IBaseResource theResource) {
        return this.extractSearchParamTokens(theResource, ALL_PARAMS);
    }

    public SearchParamSet<BaseResourceIndexedSearchParam> extractSearchParamTokens(IBaseResource var1, ISearchParamFilter var2);

    public SearchParamSet<BaseResourceIndexedSearchParam> extractSearchParamTokens(IBaseResource var1, RuntimeSearchParam var2);

    public SearchParamSet<BaseResourceIndexedSearchParam> extractSearchParamSpecial(IBaseResource var1, ISearchParamFilter var2);

    public SearchParamSet<ResourceIndexedComboStringUnique> extractSearchParamComboUnique(String var1, ResourceIndexedSearchParams var2);

    public SearchParamSet<ResourceIndexedComboTokenNonUnique> extractSearchParamComboNonUnique(String var1, ResourceIndexedSearchParams var2);

    default public SearchParamSet<ResourceIndexedSearchParamUri> extractSearchParamUri(IBaseResource theResource) {
        return this.extractSearchParamUri(theResource, ALL_PARAMS);
    }

    public SearchParamSet<ResourceIndexedSearchParamUri> extractSearchParamUri(IBaseResource var1, ISearchParamFilter var2);

    public SearchParamSet<PathAndRef> extractResourceLinks(IBaseResource var1, boolean var2);

    public String[] split(String var1);

    public List<String> extractParamValuesAsStrings(RuntimeSearchParam var1, IBaseResource var2);

    public List<IBase> extractValues(String var1, IBase var2);

    public String toRootTypeName(IBase var1);

    public String toTypeName(IBase var1);

    public PathAndRef extractReferenceLinkFromResource(IBase var1, String var2);

    public Date extractDateFromResource(IBase var1, String var2);

    public ResourceIndexedSearchParamToken createSearchParamForCoding(String var1, RuntimeSearchParam var2, IBase var3);

    public String getDisplayTextForCoding(IBase var1);

    public BaseSearchParamExtractor.IValueExtractor getPathValueExtractor(IBase var1, String var2);

    public List<IBase> getCodingsFromCodeableConcept(IBase var1);

    public String getDisplayTextFromCodeableConcept(IBase var1);

    @FunctionalInterface
    public static interface ISearchParamFilter {
        public Collection<RuntimeSearchParam> filterSearchParams(Collection<RuntimeSearchParam> var1);
    }

    public static class SearchParamSet<T>
    extends HashSet<T> {
        private List<String> myWarnings;

        public void addWarning(String theWarning) {
            if (this.myWarnings == null) {
                this.myWarnings = new ArrayList<String>();
            }
            this.myWarnings.add(theWarning);
        }

        List<String> getWarnings() {
            if (this.myWarnings == null) {
                return Collections.emptyList();
            }
            return this.myWarnings;
        }
    }
}

