/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.cache;

import ca.uhn.fhir.jpa.cache.ResourceVersionMap;
import ca.uhn.fhir.model.primitive.IdDt;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;

public class ResourceVersionCache {
    private final Map<IIdType, Long> myVersionMap = new HashMap<IIdType, Long>();

    public void clear() {
        this.myVersionMap.clear();
    }

    public Long put(IIdType theResourceId, Long theVersion) {
        return this.myVersionMap.put((IIdType)new IdDt(theResourceId).toVersionless(), theVersion);
    }

    public Long getVersionForResourceId(IIdType theResourceId) {
        return this.myVersionMap.get(new IdDt(theResourceId));
    }

    public Long removeResourceId(IIdType theResourceId) {
        return this.myVersionMap.remove(new IdDt(theResourceId));
    }

    public void initialize(ResourceVersionMap theResourceVersionMap) {
        for (IIdType resourceId : theResourceVersionMap.keySet()) {
            this.myVersionMap.put(resourceId, theResourceVersionMap.get(resourceId));
        }
    }

    public int size() {
        return this.myVersionMap.size();
    }

    public Set<IIdType> keySet() {
        return this.myVersionMap.keySet();
    }
}

