/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.cache;

import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IIdType;

public class ResourcePersistentIdMap {
    private final Map<IIdType, IResourcePersistentId> myMap = new HashMap<IIdType, IResourcePersistentId>();

    public static ResourcePersistentIdMap fromResourcePersistentIds(List<IResourcePersistentId> theResourcePersistentIds) {
        ResourcePersistentIdMap retval = new ResourcePersistentIdMap();
        theResourcePersistentIds.forEach(retval::add);
        return retval;
    }

    private void add(IResourcePersistentId theResourcePersistentId) {
        IIdType id = theResourcePersistentId.getAssociatedResourceId();
        this.myMap.put(id.toUnqualifiedVersionless(), theResourcePersistentId);
    }

    public boolean containsKey(IIdType theId) {
        return this.myMap.containsKey(theId.toUnqualifiedVersionless());
    }

    public IResourcePersistentId getResourcePersistentId(IIdType theId) {
        return this.myMap.get(theId.toUnqualifiedVersionless());
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public int size() {
        return this.myMap.size();
    }

    public void put(IIdType theId, IResourcePersistentId thePid) {
        this.myMap.put(theId, thePid);
    }

    public void putAll(ResourcePersistentIdMap theIdAndPID) {
        this.myMap.putAll(theIdAndPID.myMap);
    }
}

