/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.cache;

import ca.uhn.fhir.jpa.cache.IResourceChangeEvent;
import ca.uhn.fhir.model.primitive.IdDt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IIdType;

public class ResourceChangeEvent
implements IResourceChangeEvent {
    private final List<IIdType> myCreatedResourceIds;
    private final List<IIdType> myUpdatedResourceIds;
    private final List<IIdType> myDeletedResourceIds;

    private ResourceChangeEvent(Collection<IIdType> theCreatedResourceIds, Collection<IIdType> theUpdatedResourceIds, Collection<IIdType> theDeletedResourceIds) {
        this.myCreatedResourceIds = this.copyFrom(theCreatedResourceIds);
        this.myUpdatedResourceIds = this.copyFrom(theUpdatedResourceIds);
        this.myDeletedResourceIds = this.copyFrom(theDeletedResourceIds);
    }

    public static ResourceChangeEvent fromCreatedUpdatedDeletedResourceIds(List<IIdType> theCreatedResourceIds, List<IIdType> theUpdatedResourceIds, List<IIdType> theDeletedResourceIds) {
        return new ResourceChangeEvent(theCreatedResourceIds, theUpdatedResourceIds, theDeletedResourceIds);
    }

    private List<IIdType> copyFrom(Collection<IIdType> theResourceIds) {
        ArrayList retval = new ArrayList();
        theResourceIds.forEach(id -> retval.add(new IdDt(id)));
        return Collections.unmodifiableList(retval);
    }

    @Override
    public List<IIdType> getCreatedResourceIds() {
        return this.myCreatedResourceIds;
    }

    @Override
    public List<IIdType> getUpdatedResourceIds() {
        return this.myUpdatedResourceIds;
    }

    @Override
    public List<IIdType> getDeletedResourceIds() {
        return this.myDeletedResourceIds;
    }

    @Override
    public boolean isEmpty() {
        return this.myCreatedResourceIds.isEmpty() && this.myUpdatedResourceIds.isEmpty() && this.myDeletedResourceIds.isEmpty();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("myCreatedResourceIds", this.myCreatedResourceIds).append("myUpdatedResourceIds", this.myUpdatedResourceIds).append("myDeletedResourceIds", this.myDeletedResourceIds).toString();
    }
}

