/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.util;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.registry.SearchParameterCanonicalizer;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class SearchParameterHelper {
    private final SearchParameterCanonicalizer mySearchParameterCanonicalizer;

    public SearchParameterHelper(SearchParameterCanonicalizer theSearchParameterCanonicalizer) {
        this.mySearchParameterCanonicalizer = theSearchParameterCanonicalizer;
    }

    public Optional<SearchParameterMap> buildSearchParameterMapFromCanonical(IBaseResource theRuntimeSearchParam) {
        RuntimeSearchParam canonicalSearchParam = this.mySearchParameterCanonicalizer.canonicalizeSearchParameter(theRuntimeSearchParam);
        if (canonicalSearchParam == null) {
            return Optional.empty();
        }
        SearchParameterMap retVal = SearchParameterMap.newSynchronous();
        String theCode = canonicalSearchParam.getName();
        List<String> theBases = List.copyOf(canonicalSearchParam.getBase());
        TokenAndListParam codeParam = new TokenAndListParam().addAnd(new TokenParam[]{new TokenParam(theCode)});
        TokenAndListParam basesParam = this.toTokenAndList(theBases);
        retVal.add("code", (IQueryParameterAnd<?>)codeParam);
        retVal.add("base", (IQueryParameterAnd<?>)basesParam);
        return Optional.of(retVal);
    }

    private TokenAndListParam toTokenAndList(List<String> theBases) {
        TokenAndListParam retVal = new TokenAndListParam();
        if (theBases != null) {
            TokenOrListParam tokenOrListParam = new TokenOrListParam();
            retVal.addAnd(tokenOrListParam);
            for (String next : theBases) {
                if (!StringUtils.isNotBlank((CharSequence)next)) continue;
                tokenOrListParam.addOr(new TokenParam(next));
            }
        }
        return retVal.getValuesAsQueryTokens().isEmpty() ? null : retVal;
    }
}

