/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.extractor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.NormalizedQuantitySearchLevel;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamCoords;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamNumber;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantityNormalized;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParamComposite;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractorService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import jakarta.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class SearchParamExtractionUtil {
    private final FhirContext myFhirContext;
    private final StorageSettings myStorageSettings;
    private final ISearchParamExtractor mySearchParamExtractor;
    private final IInterceptorBroadcaster myInterceptorBroadcaster;

    public SearchParamExtractionUtil(FhirContext theFhirContext, StorageSettings theStorageSettings, ISearchParamExtractor theSearchParamExtractor, IInterceptorBroadcaster theInterceptorBroadcaster) {
        this.myFhirContext = theFhirContext;
        this.myStorageSettings = theStorageSettings;
        this.mySearchParamExtractor = theSearchParamExtractor;
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    public void extractSearchIndexParameters(RequestDetails theRequestDetails, ResourceIndexedSearchParams theParams, IBaseResource theResource, @Nonnull ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamString> strings = this.extractSearchParamStrings(theResource, theSearchParamFilter);
        SearchParamExtractorService.handleWarnings(theRequestDetails, this.myInterceptorBroadcaster, strings);
        theParams.myStringParams.addAll(strings);
        ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamNumber> numbers = this.extractSearchParamNumber(theResource, theSearchParamFilter);
        SearchParamExtractorService.handleWarnings(theRequestDetails, this.myInterceptorBroadcaster, numbers);
        theParams.myNumberParams.addAll(numbers);
        ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamQuantity> quantities = this.extractSearchParamQuantity(theResource, theSearchParamFilter);
        SearchParamExtractorService.handleWarnings(theRequestDetails, this.myInterceptorBroadcaster, quantities);
        theParams.myQuantityParams.addAll(quantities);
        if (this.myStorageSettings.getNormalizedQuantitySearchLevel().equals((Object)NormalizedQuantitySearchLevel.NORMALIZED_QUANTITY_STORAGE_SUPPORTED) || this.myStorageSettings.getNormalizedQuantitySearchLevel().equals((Object)NormalizedQuantitySearchLevel.NORMALIZED_QUANTITY_SEARCH_SUPPORTED)) {
            ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamQuantityNormalized> quantitiesNormalized = this.extractSearchParamQuantityNormalized(theResource, theSearchParamFilter);
            SearchParamExtractorService.handleWarnings(theRequestDetails, this.myInterceptorBroadcaster, quantitiesNormalized);
            theParams.myQuantityNormalizedParams.addAll(quantitiesNormalized);
        }
        ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamDate> dates = this.extractSearchParamDates(theResource, theSearchParamFilter);
        SearchParamExtractorService.handleWarnings(theRequestDetails, this.myInterceptorBroadcaster, dates);
        theParams.myDateParams.addAll(dates);
        ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamUri> uris = this.extractSearchParamUri(theResource, theSearchParamFilter);
        SearchParamExtractorService.handleWarnings(theRequestDetails, this.myInterceptorBroadcaster, uris);
        theParams.myUriParams.addAll(uris);
        ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> tokens = this.extractSearchParamTokens(theResource, theSearchParamFilter);
        for (BaseResourceIndexedSearchParam next : tokens) {
            if (next instanceof ResourceIndexedSearchParamToken) {
                theParams.myTokenParams.add((ResourceIndexedSearchParamToken)next);
                continue;
            }
            if (next instanceof ResourceIndexedSearchParamCoords) {
                theParams.myCoordsParams.add((ResourceIndexedSearchParamCoords)next);
                continue;
            }
            theParams.myStringParams.add((ResourceIndexedSearchParamString)next);
        }
        if (this.myFhirContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3)) {
            ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamComposite> composites = this.extractSearchParamComposites(theResource, theSearchParamFilter);
            SearchParamExtractorService.handleWarnings(theRequestDetails, this.myInterceptorBroadcaster, composites);
            theParams.myCompositeParams.addAll(composites);
        }
        ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> specials = this.extractSearchParamSpecial(theResource, theSearchParamFilter);
        for (BaseResourceIndexedSearchParam next : specials) {
            if (!(next instanceof ResourceIndexedSearchParamCoords)) continue;
            theParams.myCoordsParams.add((ResourceIndexedSearchParamCoords)next);
        }
    }

    private ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamDate> extractSearchParamDates(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        return this.mySearchParamExtractor.extractSearchParamDates(theResource, theSearchParamFilter);
    }

    private ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamNumber> extractSearchParamNumber(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        return this.mySearchParamExtractor.extractSearchParamNumber(theResource, theSearchParamFilter);
    }

    private ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamQuantity> extractSearchParamQuantity(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        return this.mySearchParamExtractor.extractSearchParamQuantity(theResource, theSearchParamFilter);
    }

    private ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamQuantityNormalized> extractSearchParamQuantityNormalized(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        return this.mySearchParamExtractor.extractSearchParamQuantityNormalized(theResource, theSearchParamFilter);
    }

    private ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamString> extractSearchParamStrings(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        return this.mySearchParamExtractor.extractSearchParamStrings(theResource, theSearchParamFilter);
    }

    private ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> extractSearchParamTokens(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        return this.mySearchParamExtractor.extractSearchParamTokens(theResource, theSearchParamFilter);
    }

    private ISearchParamExtractor.SearchParamSet<BaseResourceIndexedSearchParam> extractSearchParamSpecial(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        return this.mySearchParamExtractor.extractSearchParamSpecial(theResource, theSearchParamFilter);
    }

    private ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamUri> extractSearchParamUri(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        return this.mySearchParamExtractor.extractSearchParamUri(theResource, theSearchParamFilter);
    }

    private ISearchParamExtractor.SearchParamSet<ResourceIndexedSearchParamComposite> extractSearchParamComposites(IBaseResource theResource, ISearchParamExtractor.ISearchParamFilter theSearchParamFilter) {
        return this.mySearchParamExtractor.extractSearchParamComposites(theResource, theSearchParamFilter);
    }
}

