/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.extractor;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class PathAndRef {
    private final String myPath;
    private final IBaseReference myRef;
    private final IBaseResource myResource;
    private final String mySearchParamName;
    private final boolean myCanonical;

    public PathAndRef(String theSearchParamName, String thePath, IBaseReference theRef, boolean theCanonical) {
        this.mySearchParamName = theSearchParamName;
        this.myPath = thePath;
        this.myRef = theRef;
        this.myCanonical = theCanonical;
        this.myResource = null;
    }

    public PathAndRef(String theSearchParamName, String thePath, IBaseResource theResource) {
        this.mySearchParamName = theSearchParamName;
        this.myPath = thePath;
        this.myRef = null;
        this.myCanonical = false;
        this.myResource = theResource;
    }

    public IBaseResource getResource() {
        return this.myResource;
    }

    public boolean isCanonical() {
        return this.myCanonical;
    }

    public String getSearchParamName() {
        return this.mySearchParamName;
    }

    public String getPath() {
        return this.myPath;
    }

    public IBaseReference getRef() {
        return this.myRef;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("paramName", (Object)this.mySearchParamName);
        if (this.myRef != null && this.myRef.getReferenceElement() != null) {
            b.append("ref", (Object)this.myRef.getReferenceElement().getValue());
        }
        b.append("path", (Object)this.myPath);
        b.append("resource", (Object)this.myResource);
        b.append("canonical", this.myCanonical);
        return b.toString();
    }
}

