/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.extractor;

public class GeopointNormalizer {
    static int WHOLE_CIRCLE_DEGREE_RANGE;
    static int LONGITUDE_DEGREE_RANGE;
    static int LATITUDE_DEGREE_RANGE;
    static int LATITUDE_DEGREE_MIN;
    static int LATITUDE_DEGREE_MAX;

    public static double normalizeLongitude(double longitude) {
        if (longitude == (double)(-LONGITUDE_DEGREE_RANGE / 2)) {
            return LONGITUDE_DEGREE_RANGE / 2;
        }
        return GeopointNormalizer.normalizeLongitudeInclusive(longitude);
    }

    public static double normalizeLongitudeInclusive(double longitude) {
        if (longitude < (double)(-(LONGITUDE_DEGREE_RANGE / 2)) || longitude > (double)(LONGITUDE_DEGREE_RANGE / 2)) {
            double _longitude = (longitude + (double)(LONGITUDE_DEGREE_RANGE / 2)) % (double)WHOLE_CIRCLE_DEGREE_RANGE;
            _longitude = _longitude < 0.0 ? (_longitude += (double)(LONGITUDE_DEGREE_RANGE / 2)) : (_longitude -= (double)(LONGITUDE_DEGREE_RANGE / 2));
            return _longitude;
        }
        return longitude;
    }

    public static double normalizeLatitude(double latitude) {
        if (latitude > (double)LATITUDE_DEGREE_MAX || latitude < (double)LATITUDE_DEGREE_MIN) {
            double _latitude = Math.abs((latitude + (double)(LATITUDE_DEGREE_RANGE / 2)) % (double)WHOLE_CIRCLE_DEGREE_RANGE);
            if (_latitude > (double)LATITUDE_DEGREE_RANGE) {
                _latitude = (double)WHOLE_CIRCLE_DEGREE_RANGE - _latitude;
            }
            return _latitude -= (double)(LATITUDE_DEGREE_RANGE / 2);
        }
        return latitude;
    }

    static {
        LONGITUDE_DEGREE_RANGE = WHOLE_CIRCLE_DEGREE_RANGE = 360;
        LATITUDE_DEGREE_RANGE = WHOLE_CIRCLE_DEGREE_RANGE / 2;
        LATITUDE_DEGREE_MIN = -LATITUDE_DEGREE_RANGE / 2;
        LATITUDE_DEGREE_MAX = LATITUDE_DEGREE_RANGE / 2;
    }
}

