/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.searchparam.ResourceMetaParams;
import ca.uhn.fhir.jpa.searchparam.ResourceSearch;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.MatchUrlUtil;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.springframework.beans.factory.annotation.Autowired;

public class MatchUrlService {
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;

    /*
     * WARNING - void declaration
     */
    public SearchParameterMap translateMatchUrl(String theMatchUrl, RuntimeResourceDefinition theResourceDefinition, Flag ... theFlags) {
        SearchParameterMap paramMap = new SearchParameterMap();
        List parameters = MatchUrlUtil.translateMatchUrl((String)theMatchUrl);
        ArrayListMultimap nameToParamLists = ArrayListMultimap.create();
        for (NameValuePair next : parameters) {
            void var10_10;
            if (StringUtils.isBlank((CharSequence)next.getValue())) continue;
            String paramName = next.getName();
            Object var10_11 = null;
            for (int i = 0; i < paramName.length(); ++i) {
                switch (paramName.charAt(i)) {
                    case '.': 
                    case ':': {
                        String string = paramName.substring(i);
                        paramName = paramName.substring(0, i);
                        i = 0x7FFFFFFE;
                    }
                }
            }
            QualifiedParamList paramList = QualifiedParamList.splitQueryStringByCommasIgnoreEscape((String)var10_10, (String)next.getValue());
            nameToParamLists.put((Object)paramName, (Object)paramList);
        }
        for (String nextParamName : nameToParamLists.keySet()) {
            List paramList = nameToParamLists.get((Object)nextParamName);
            if (theFlags != null) {
                for (Flag next : theFlags) {
                    next.process(nextParamName, paramList, paramMap);
                }
            }
            if ("_lastUpdated".equals(nextParamName)) {
                if (paramList.isEmpty()) continue;
                if (paramList.size() > 2) {
                    throw new InvalidRequestException(Msg.code((int)484) + "Failed to parse match URL[" + theMatchUrl + "] - Can not have more than 2 _lastUpdated parameter repetitions");
                }
                DateRangeParam dateRangeParam = new DateRangeParam();
                dateRangeParam.setValuesAsQueryTokens(this.myFhirContext, nextParamName, paramList);
                paramMap.setLastUpdated(dateRangeParam);
                continue;
            }
            if ("_has".equals(nextParamName)) {
                IQueryParameterAnd<?> iQueryParameterAnd = JpaParamUtil.parseQueryParams(this.myFhirContext, RestSearchParameterTypeEnum.HAS, nextParamName, paramList);
                paramMap.add(nextParamName, iQueryParameterAnd);
                continue;
            }
            if ("_count".equals(nextParamName)) {
                if (paramList.isEmpty() || ((QualifiedParamList)paramList.get(0)).isEmpty()) continue;
                String string = (String)((QualifiedParamList)paramList.get(0)).get(0);
                try {
                    paramMap.setCount(Integer.parseInt(string));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new InvalidRequestException(Msg.code((int)485) + "Invalid _count value: " + string);
                }
            }
            if ("_total".equals(nextParamName)) {
                if (paramList.isEmpty() || ((QualifiedParamList)paramList.get(0)).isEmpty()) continue;
                String string = (String)((QualifiedParamList)paramList.get(0)).get(0);
                SearchTotalModeEnum searchTotalMode = SearchTotalModeEnum.fromCode((String)string);
                if (searchTotalMode == null) {
                    try {
                        searchTotalMode = SearchTotalModeEnum.valueOf((String)string);
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvalidRequestException(Msg.code((int)2078) + "Invalid _total value: " + string);
                    }
                }
                paramMap.setSearchTotalMode(searchTotalMode);
                continue;
            }
            if ("_offset".equals(nextParamName)) {
                if (paramList.isEmpty() || ((QualifiedParamList)paramList.get(0)).isEmpty()) continue;
                String string = (String)((QualifiedParamList)paramList.get(0)).get(0);
                try {
                    paramMap.setOffset(Integer.parseInt(string));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new InvalidRequestException(Msg.code((int)486) + "Invalid _offset value: " + string);
                }
            }
            if (ResourceMetaParams.RESOURCE_META_PARAMS.containsKey(nextParamName)) {
                if (StringUtils.isNotBlank((CharSequence)((QualifiedParamList)paramList.get(0)).getQualifier()) && ((QualifiedParamList)paramList.get(0)).getQualifier().startsWith(".")) {
                    throw new InvalidRequestException(Msg.code((int)487) + "Invalid parameter chain: " + nextParamName + ((QualifiedParamList)paramList.get(0)).getQualifier());
                }
                IQueryParameterAnd<?> iQueryParameterAnd = this.newInstanceAnd(nextParamName);
                iQueryParameterAnd.setValuesAsQueryTokens(this.myFhirContext, nextParamName, paramList);
                paramMap.add(nextParamName, iQueryParameterAnd);
                continue;
            }
            if ("_source".equals(nextParamName)) {
                IQueryParameterAnd<?> iQueryParameterAnd = JpaParamUtil.parseQueryParams(this.myFhirContext, RestSearchParameterTypeEnum.URI, nextParamName, paramList);
                paramMap.add(nextParamName, iQueryParameterAnd);
                continue;
            }
            if ("_expunge".equals(nextParamName)) {
                paramMap.setDeleteExpunge(true);
                continue;
            }
            if ("_list".equals(nextParamName)) {
                IQueryParameterAnd<?> iQueryParameterAnd = JpaParamUtil.parseQueryParams(this.myFhirContext, RestSearchParameterTypeEnum.TOKEN, nextParamName, paramList);
                paramMap.add(nextParamName, iQueryParameterAnd);
                continue;
            }
            if (nextParamName.startsWith("_") && !"_language".equals(nextParamName)) continue;
            RuntimeSearchParam runtimeSearchParam = this.mySearchParamRegistry.getActiveSearchParam(theResourceDefinition.getName(), nextParamName, ISearchParamRegistry.SearchParamLookupContextEnum.SEARCH);
            if (runtimeSearchParam == null) {
                throw this.throwUnrecognizedParamException(theMatchUrl, theResourceDefinition, nextParamName);
            }
            IQueryParameterAnd<?> param2 = JpaParamUtil.parseQueryParams(this.mySearchParamRegistry, this.myFhirContext, runtimeSearchParam, nextParamName, paramList);
            paramMap.add(nextParamName, param2);
        }
        return paramMap;
    }

    private InvalidRequestException throwUnrecognizedParamException(String theMatchUrl, RuntimeResourceDefinition theResourceDefinition, String nextParamName) {
        return new UnrecognizedSearchParameterException(Msg.code((int)488) + "Failed to parse match URL[" + theMatchUrl + "] - Resource type " + theResourceDefinition.getName() + " does not have a parameter with name: " + nextParamName, theResourceDefinition.getName(), nextParamName);
    }

    private IQueryParameterAnd<?> newInstanceAnd(String theParamType) {
        Class<? extends IQueryParameterAnd<?>> clazz = ResourceMetaParams.RESOURCE_META_AND_PARAMS.get(theParamType);
        return (IQueryParameterAnd)ReflectionUtil.newInstance(clazz);
    }

    public IQueryParameterType newInstanceType(String theParamType) {
        Class<? extends IQueryParameterType> clazz = ResourceMetaParams.RESOURCE_META_PARAMS.get(theParamType);
        return (IQueryParameterType)ReflectionUtil.newInstance(clazz);
    }

    public ResourceSearch getResourceSearch(String theUrl, RequestPartitionId theRequestPartitionId, Flag ... theFlags) {
        RuntimeResourceDefinition resourceDefinition = UrlUtil.parseUrlResourceType((FhirContext)this.myFhirContext, (String)theUrl);
        SearchParameterMap searchParameterMap = this.translateMatchUrl(theUrl, resourceDefinition, theFlags);
        return new ResourceSearch(resourceDefinition, searchParameterMap, theRequestPartitionId);
    }

    public ResourceSearch getResourceSearch(String theUrl) {
        return this.getResourceSearch(theUrl, null, new Flag[0]);
    }

    public ResourceSearch getResourceSearchWithIncludesAndRevIncludes(String theUrl) {
        return this.getResourceSearch(theUrl, null, MatchUrlService.processIncludes());
    }

    public static Flag processIncludes() {
        return (theParamName, theValues, theMapToPopulate) -> {
            block5: {
                block4: {
                    if (!"_include".equals(theParamName)) break block4;
                    for (QualifiedParamList nextQualifiedList : theValues) {
                        for (String nextValue : nextQualifiedList) {
                            theMapToPopulate.addInclude(new Include(nextValue, ParameterUtil.isIncludeIterate((String)nextQualifiedList.getQualifier())));
                        }
                    }
                    break block5;
                }
                if (!"_revinclude".equals(theParamName)) break block5;
                for (QualifiedParamList nextQualifiedList : theValues) {
                    for (String nextValue : nextQualifiedList) {
                        theMapToPopulate.addRevInclude(new Include(nextValue, ParameterUtil.isIncludeIterate((String)nextQualifiedList.getQualifier())));
                    }
                }
            }
        };
    }

    public static interface Flag {
        public void process(String var1, List<QualifiedParamList> var2, SearchParameterMap var3);
    }

    public static class UnrecognizedSearchParameterException
    extends InvalidRequestException {
        private final String myResourceName;
        private final String myParamName;

        UnrecognizedSearchParameterException(String theMessage, String theResourceName, String theParamName) {
            super(theMessage);
            this.myResourceName = theResourceName;
            this.myParamName = theParamName;
        }

        public String getResourceName() {
            return this.myResourceName;
        }

        public String getParamName() {
            return this.myParamName;
        }
    }
}

