/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.cache;

import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.model.primitive.IdDt;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceVersionMap {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceVersionMap.class);
    private final Set<IIdType> mySourceIds = new HashSet<IIdType>();
    private final Map<IIdType, Long> myMap = new HashMap<IIdType, Long>();

    private ResourceVersionMap() {
    }

    public static ResourceVersionMap fromResourceTableEntities(List<? extends IBasePersistedResource<?>> theEntities) {
        ResourceVersionMap retval = new ResourceVersionMap();
        theEntities.forEach(entity -> retval.add(entity.getIdDt()));
        return retval;
    }

    public static ResourceVersionMap fromResources(List<? extends IBaseResource> theResources) {
        ResourceVersionMap retval = new ResourceVersionMap();
        theResources.forEach(resource -> retval.add(resource.getIdElement()));
        return retval;
    }

    public static ResourceVersionMap empty() {
        return new ResourceVersionMap();
    }

    public static ResourceVersionMap fromIdsWithVersions(List<IIdType> theFhirIds) {
        ResourceVersionMap retval = new ResourceVersionMap();
        theFhirIds.forEach(retval::add);
        return retval;
    }

    private void add(IIdType theId) {
        if (theId.getVersionIdPart() == null) {
            ourLog.warn("Not storing {} in ResourceVersionMap because it does not have a version.", (Object)theId);
            return;
        }
        IdDt id = new IdDt(theId);
        this.mySourceIds.add((IIdType)id);
        this.myMap.put((IIdType)id.toUnqualifiedVersionless(), id.getVersionIdPartAsLong());
    }

    public Long getVersion(IIdType theResourceId) {
        return this.get(theResourceId);
    }

    public int size() {
        return this.myMap.size();
    }

    public Set<IIdType> keySet() {
        return Collections.unmodifiableSet(this.myMap.keySet());
    }

    public Set<IIdType> getSourceIds() {
        return Collections.unmodifiableSet(this.mySourceIds);
    }

    public Long get(IIdType theId) {
        return this.myMap.get(new IdDt(theId.toUnqualifiedVersionless()));
    }

    public boolean containsKey(IIdType theId) {
        return this.myMap.containsKey(new IdDt(theId.toUnqualifiedVersionless()));
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }
}

