/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.cache;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.cache.IResourceChangeListener;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerCache;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerCacheRefresher;
import ca.uhn.fhir.jpa.cache.ResourceChangeResult;
import ca.uhn.fhir.jpa.cache.ResourceVersionCache;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.SearchParamMatcher;
import ca.uhn.fhir.jpa.searchparam.retry.Retrier;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ResourceChangeListenerCache
implements IResourceChangeListenerCache {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceChangeListenerCache.class);
    private static final int MAX_RETRIES = 60;
    private static Instant ourNowForUnitTests;
    @Autowired
    IResourceChangeListenerCacheRefresher myResourceChangeListenerCacheRefresher;
    @Autowired
    SearchParamMatcher mySearchParamMatcher;
    private final String myResourceName;
    private final IResourceChangeListener myResourceChangeListener;
    private final SearchParameterMap mySearchParameterMap;
    private final ResourceVersionCache myResourceVersionCache = new ResourceVersionCache();
    private final long myRemoteRefreshIntervalMs;
    private boolean myInitialized = false;
    private Instant myNextRefreshTime = Instant.MIN;

    public ResourceChangeListenerCache(String theResourceName, IResourceChangeListener theResourceChangeListener, SearchParameterMap theSearchParameterMap, long theRemoteRefreshIntervalMs) {
        this.myResourceName = theResourceName;
        this.myResourceChangeListener = theResourceChangeListener;
        this.mySearchParameterMap = (SearchParameterMap)SerializationUtils.clone((Serializable)theSearchParameterMap);
        this.myRemoteRefreshIntervalMs = theRemoteRefreshIntervalMs;
    }

    @Override
    public void requestRefresh() {
        this.myNextRefreshTime = Instant.MIN;
    }

    @Override
    public ResourceChangeResult forceRefresh() {
        this.requestRefresh();
        return this.refreshCacheWithRetry();
    }

    public void requestRefreshIfWatching(IBaseResource theResource) {
        if (this.matches(theResource)) {
            this.requestRefresh();
        }
    }

    public boolean matches(IBaseResource theResource) {
        InMemoryMatchResult result = this.mySearchParamMatcher.match(this.mySearchParameterMap, theResource);
        if (!result.supported()) {
            throw new IllegalStateException(Msg.code((int)483) + "Search Parameter Map " + String.valueOf(this.mySearchParameterMap) + " cannot be processed in-memory: " + result.getUnsupportedReason());
        }
        return result.matched();
    }

    @Override
    public ResourceChangeResult refreshCacheIfNecessary() {
        ResourceChangeResult retval = new ResourceChangeResult();
        if (this.isTimeToRefresh()) {
            retval = this.refreshCacheWithRetry();
        }
        return retval;
    }

    protected boolean isTimeToRefresh() {
        return this.myNextRefreshTime.isBefore(ResourceChangeListenerCache.now());
    }

    static Instant now() {
        if (ourNowForUnitTests != null) {
            return ourNowForUnitTests;
        }
        return Instant.now();
    }

    public ResourceChangeResult refreshCacheWithRetry() {
        ResourceChangeResult retval;
        try {
            retval = this.refreshCacheAndNotifyListenersWithRetry();
        }
        finally {
            this.myNextRefreshTime = ResourceChangeListenerCache.now().plus(Duration.ofMillis(this.myRemoteRefreshIntervalMs));
        }
        return retval;
    }

    @VisibleForTesting
    public void setResourceChangeListenerCacheRefresher(IResourceChangeListenerCacheRefresher theResourceChangeListenerCacheRefresher) {
        this.myResourceChangeListenerCacheRefresher = theResourceChangeListenerCacheRefresher;
    }

    private ResourceChangeResult refreshCacheAndNotifyListenersWithRetry() {
        Retrier<ResourceChangeResult> refreshCacheRetrier = new Retrier<ResourceChangeResult>(() -> {
            ResourceChangeListenerCache resourceChangeListenerCache = this;
            synchronized (resourceChangeListenerCache) {
                return this.myResourceChangeListenerCacheRefresher.refreshCacheAndNotifyListener(this);
            }
        }, ResourceChangeListenerCache.getMaxRetries());
        return refreshCacheRetrier.runWithRetry();
    }

    @Override
    public Instant getNextRefreshTime() {
        return this.myNextRefreshTime;
    }

    @Override
    public SearchParameterMap getSearchParameterMap() {
        return this.mySearchParameterMap;
    }

    @Override
    public boolean isInitialized() {
        return this.myInitialized;
    }

    public ResourceChangeListenerCache setInitialized(boolean theInitialized) {
        this.myInitialized = theInitialized;
        return this;
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    public ResourceVersionCache getResourceVersionCache() {
        return this.myResourceVersionCache;
    }

    public IResourceChangeListener getResourceChangeListener() {
        return this.myResourceChangeListener;
    }

    @VisibleForTesting
    public static void setNowForUnitTests(String theTime) {
        if (theTime == null) {
            ourNowForUnitTests = null;
            return;
        }
        String datetime = "2020-11-16T" + theTime + "Z";
        Clock clock = Clock.fixed(Instant.parse(datetime), ZoneId.systemDefault());
        ourNowForUnitTests = Instant.now(clock);
    }

    @VisibleForTesting
    Instant getNextRefreshTimeForUnitTest() {
        return this.myNextRefreshTime;
    }

    @VisibleForTesting
    public void clearForUnitTest() {
        this.requestRefresh();
        this.myResourceVersionCache.clear();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("myResourceName", (Object)this.myResourceName).append("mySearchParameterMap", (Object)this.mySearchParameterMap).append("myInitialized", this.myInitialized).toString();
    }

    static int getMaxRetries() {
        return 60;
    }
}

