/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.util;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class SearchParamHash {
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_128((int)0);
    private static final byte[] DELIMITER_BYTES = "|".getBytes(Charsets.UTF_8);

    private SearchParamHash() {
    }

    public static long hashSearchParam(@Nonnull PartitionSettings thePartitionSettings, @Nonnull RequestPartitionId theRequestPartitionId, String ... theValues) {
        return SearchParamHash.doHashSearchParam(thePartitionSettings, theRequestPartitionId, theValues);
    }

    public static long hashSearchParam(String ... theValues) {
        return SearchParamHash.doHashSearchParam(null, null, theValues);
    }

    private static long doHashSearchParam(@Nullable PartitionSettings thePartitionSettings, @Nullable RequestPartitionId theRequestPartitionId, @Nonnull String[] theValues) {
        Hasher hasher = HASH_FUNCTION.newHasher();
        if (thePartitionSettings != null && theRequestPartitionId != null && thePartitionSettings.isPartitioningEnabled() && thePartitionSettings.isIncludePartitionInSearchHashes()) {
            if (theRequestPartitionId.getPartitionIds().size() > 1) {
                throw new InternalErrorException(Msg.code((int)1527) + "Can not search multiple partitions when partitions are included in search hashes");
            }
            Integer partitionId = theRequestPartitionId.getFirstPartitionIdOrNull();
            if (partitionId != null) {
                hasher.putInt(partitionId.intValue());
            }
        }
        for (String next : theValues) {
            if (next == null) {
                hasher.putByte((byte)0);
            } else {
                next = UrlUtil.escapeUrlParam((String)next);
                byte[] bytes = next.getBytes(Charsets.UTF_8);
                hasher.putBytes(bytes);
            }
            hasher.putBytes(DELIMITER_BYTES);
        }
        HashCode hashCode = hasher.hash();
        long retVal = hashCode.asLong();
        return retVal;
    }
}

