/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.listener;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexStorageOptimizationListener {
    private final StorageSettings myStorageSettings;

    public IndexStorageOptimizationListener(@Autowired StorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    @PrePersist
    @PreUpdate
    public void optimizeSearchParams(Object theEntity) {
        if (theEntity instanceof BaseResourceIndexedSearchParam) {
            if (this.myStorageSettings.isIndexStorageOptimized()) {
                ((BaseResourceIndexedSearchParam)theEntity).optimizeIndexStorage();
            }
            ((BaseResourceIndexedSearchParam)theEntity).setUpdated(null);
        }
    }
}

