/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.model.entity.NormalizedQuantitySearchLevel;
import ca.uhn.fhir.jpa.util.ISequenceValueMassager;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.DateTimeType;

public class StorageSettings {
    public static final int DEFAULT_BUNDLE_BATCH_POOL_SIZE = 20;
    public static final int DEFAULT_BUNDLE_BATCH_MAX_POOL_SIZE = 100;
    public static final Set<String> DEFAULT_LOGICAL_BASE_URLS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("http://hl7.org/fhir/ValueSet/*", "http://hl7.org/fhir/CodeSystem/*", "http://hl7.org/fhir/valueset-*", "http://hl7.org/fhir/codesystem-*", "http://hl7.org/fhir/StructureDefinition/*")));
    protected static final String DEFAULT_PERIOD_INDEX_START_OF_TIME = "1001-01-01";
    protected static final String DEFAULT_PERIOD_INDEX_END_OF_TIME = "9000-01-01";
    private static final Integer DEFAULT_MAXIMUM_TRANSACTION_BUNDLE_SIZE = null;
    public static final TagStorageModeEnum DEFAULT_TAG_STORAGE_MODE = TagStorageModeEnum.VERSIONED;
    private boolean myAllowContainsSearches = false;
    private boolean myAllowExternalReferences = false;
    private Set<String> myTreatBaseUrlsAsLocal = new HashSet<String>();
    private Set<String> myTreatReferencesAsLogical = new HashSet<String>(DEFAULT_LOGICAL_BASE_URLS);
    private boolean myDefaultSearchParamsCanBeOverridden = true;
    private boolean myAutoCreatePlaceholderReferenceTargets;
    private Integer myBundleBatchPoolSize = 20;
    private Integer myBundleBatchMaxPoolSize = 100;
    private boolean myMassIngestionMode;
    private Integer myMaximumTransactionBundleSize = DEFAULT_MAXIMUM_TRANSACTION_BUNDLE_SIZE;
    private TagStorageModeEnum myTagStorageMode = DEFAULT_TAG_STORAGE_MODE;
    private boolean myHibernateSearchIndexFullText = false;
    private boolean myNormalizeTerminologyForBulkExportJobs = false;
    private boolean myUseOrdinalDatesForDayPrecisionSearches = true;
    private boolean mySuppressStringIndexingInTokens = false;
    private Class<? extends ISequenceValueMassager> mySequenceValueMassagerClass;
    private IPrimitiveType<Date> myPeriodIndexStartOfTime;
    private IPrimitiveType<Date> myPeriodIndexEndOfTime;
    private NormalizedQuantitySearchLevel myNormalizedQuantitySearchLevel;
    private Set<String> myAutoVersionReferenceAtPaths = Collections.emptySet();
    private Map<String, Set<String>> myTypeToAutoVersionReferenceAtPaths = Collections.emptyMap();
    private boolean myRespectVersionsForSearchIncludes;
    private boolean myIndexOnUpliftedRefchains = false;
    private boolean myIndexOnContainedResources = false;
    private boolean myIndexOnContainedResourcesRecursively = false;
    private boolean myAllowMdmExpansion = false;
    private boolean myAutoSupportDefaultSearchParams = true;
    private boolean myIndexIdentifierOfType = false;
    private IndexEnabledEnum myIndexMissingFieldsEnabled = IndexEnabledEnum.DISABLED;
    private boolean myLanguageSearchParameterEnabled = false;
    private boolean myValidateResourceStatusForPackageUpload = true;
    private boolean myIndexStorageOptimized = false;

    public StorageSettings() {
        this.setSequenceValueMassagerClass(ISequenceValueMassager.NoopSequenceValueMassager.class);
        this.setPeriodIndexStartOfTime((IPrimitiveType<Date>)new DateTimeType(DEFAULT_PERIOD_INDEX_START_OF_TIME));
        this.setPeriodIndexEndOfTime((IPrimitiveType<Date>)new DateTimeType(DEFAULT_PERIOD_INDEX_END_OF_TIME));
        this.setNormalizedQuantitySearchLevel(NormalizedQuantitySearchLevel.NORMALIZED_QUANTITY_SEARCH_NOT_SUPPORTED);
    }

    public boolean isAutoCreatePlaceholderReferenceTargets() {
        return this.myAutoCreatePlaceholderReferenceTargets;
    }

    public void setAutoCreatePlaceholderReferenceTargets(boolean theAutoCreatePlaceholderReferenceTargets) {
        this.myAutoCreatePlaceholderReferenceTargets = theAutoCreatePlaceholderReferenceTargets;
    }

    public Integer getBundleBatchPoolSize() {
        return this.myBundleBatchPoolSize;
    }

    public void setBundleBatchPoolSize(Integer theBundleBatchPoolSize) {
        this.myBundleBatchPoolSize = theBundleBatchPoolSize;
    }

    public Integer getBundleBatchMaxPoolSize() {
        return this.myBundleBatchMaxPoolSize;
    }

    public void setBundleBatchMaxPoolSize(Integer theBundleBatchMaxPoolSize) {
        this.myBundleBatchMaxPoolSize = theBundleBatchMaxPoolSize;
    }

    public IndexEnabledEnum getIndexMissingFields() {
        return this.myIndexMissingFieldsEnabled;
    }

    public boolean isHibernateSearchIndexFullText() {
        return this.myHibernateSearchIndexFullText;
    }

    public void setHibernateSearchIndexFullText(boolean theHibernateSearchIndexFullText) {
        this.myHibernateSearchIndexFullText = theHibernateSearchIndexFullText;
    }

    public void setIndexMissingFields(IndexEnabledEnum theIndexMissingFields) {
        Validate.notNull((Object)((Object)theIndexMissingFields), (String)"theIndexMissingFields must not be null", (Object[])new Object[0]);
        this.myIndexMissingFieldsEnabled = theIndexMissingFields;
    }

    public boolean isIndexStorageOptimized() {
        return this.myIndexStorageOptimized;
    }

    public void setIndexStorageOptimized(boolean theIndexStorageOptimized) {
        this.myIndexStorageOptimized = theIndexStorageOptimized;
    }

    public boolean isMassIngestionMode() {
        return this.myMassIngestionMode;
    }

    public void setMassIngestionMode(boolean theMassIngestionMode) {
        this.myMassIngestionMode = theMassIngestionMode;
    }

    public Integer getMaximumTransactionBundleSize() {
        return this.myMaximumTransactionBundleSize;
    }

    public StorageSettings setMaximumTransactionBundleSize(Integer theMaximumTransactionBundleSize) {
        this.myMaximumTransactionBundleSize = theMaximumTransactionBundleSize;
        return this;
    }

    public boolean isNormalizeTerminologyForBulkExportJobs() {
        return this.myNormalizeTerminologyForBulkExportJobs;
    }

    public void setNormalizeTerminologyForBulkExportJobs(boolean theNormalizeTerminologyForBulkExportJobs) {
        this.myNormalizeTerminologyForBulkExportJobs = theNormalizeTerminologyForBulkExportJobs;
    }

    public Class<? extends ISequenceValueMassager> getSequenceValueMassagerClass() {
        return this.mySequenceValueMassagerClass;
    }

    public void setSequenceValueMassagerClass(Class<? extends ISequenceValueMassager> theSequenceValueMassagerClass) {
        Validate.notNull(theSequenceValueMassagerClass, (String)"theSequenceValueMassagerClass must not be null", (Object[])new Object[0]);
        this.mySequenceValueMassagerClass = theSequenceValueMassagerClass;
    }

    @Nonnull
    public TagStorageModeEnum getTagStorageMode() {
        return this.myTagStorageMode;
    }

    public void setTagStorageMode(@Nonnull TagStorageModeEnum theTagStorageMode) {
        Validate.notNull((Object)((Object)theTagStorageMode), (String)"theTagStorageMode must not be null", (Object[])new Object[0]);
        this.myTagStorageMode = theTagStorageMode;
    }

    public boolean isIndexIdentifierOfType() {
        return this.myIndexIdentifierOfType;
    }

    public void setIndexIdentifierOfType(boolean theIndexIdentifierOfType) {
        this.myIndexIdentifierOfType = theIndexIdentifierOfType;
    }

    public boolean isDefaultSearchParamsCanBeOverridden() {
        return this.myDefaultSearchParamsCanBeOverridden;
    }

    public void setDefaultSearchParamsCanBeOverridden(boolean theDefaultSearchParamsCanBeOverridden) {
        this.myDefaultSearchParamsCanBeOverridden = theDefaultSearchParamsCanBeOverridden;
    }

    public boolean isAllowContainsSearches() {
        return this.myAllowContainsSearches;
    }

    public void setAllowContainsSearches(boolean theAllowContainsSearches) {
        this.myAllowContainsSearches = theAllowContainsSearches;
    }

    public boolean isAllowMdmExpansion() {
        return this.myAllowMdmExpansion;
    }

    public void setAllowMdmExpansion(boolean theAllowMdmExpansion) {
        this.myAllowMdmExpansion = theAllowMdmExpansion;
    }

    public boolean isAllowExternalReferences() {
        return this.myAllowExternalReferences;
    }

    public void setAllowExternalReferences(boolean theAllowExternalReferences) {
        this.myAllowExternalReferences = theAllowExternalReferences;
    }

    public Set<String> getTreatBaseUrlsAsLocal() {
        return this.myTreatBaseUrlsAsLocal;
    }

    public void setTreatBaseUrlsAsLocal(Set<String> theTreatBaseUrlsAsLocal) {
        if (theTreatBaseUrlsAsLocal != null) {
            for (String next : theTreatBaseUrlsAsLocal) {
                StorageSettings.validateTreatBaseUrlsAsLocal(next);
            }
        }
        HashSet<String> treatBaseUrlsAsLocal = new HashSet<String>();
        for (String next : (Set)ObjectUtils.defaultIfNull(theTreatBaseUrlsAsLocal, new HashSet())) {
            while (next.endsWith("/")) {
                next = next.substring(0, next.length() - 1);
            }
            treatBaseUrlsAsLocal.add(next);
        }
        this.myTreatBaseUrlsAsLocal = treatBaseUrlsAsLocal;
    }

    public void addTreatReferencesAsLogical(String theTreatReferencesAsLogical) {
        StorageSettings.validateTreatBaseUrlsAsLocal(theTreatReferencesAsLogical);
        if (this.myTreatReferencesAsLogical == null) {
            this.myTreatReferencesAsLogical = new HashSet<String>();
        }
        this.myTreatReferencesAsLogical.add(theTreatReferencesAsLogical);
    }

    public Set<String> getTreatReferencesAsLogical() {
        return this.myTreatReferencesAsLogical;
    }

    public StorageSettings setTreatReferencesAsLogical(Set<String> theTreatReferencesAsLogical) {
        this.myTreatReferencesAsLogical = theTreatReferencesAsLogical;
        return this;
    }

    public boolean getUseOrdinalDatesForDayPrecisionSearches() {
        return this.myUseOrdinalDatesForDayPrecisionSearches;
    }

    public void setUseOrdinalDatesForDayPrecisionSearches(boolean theUseOrdinalDates) {
        this.myUseOrdinalDatesForDayPrecisionSearches = theUseOrdinalDates;
    }

    public boolean isSuppressStringIndexingInTokens() {
        return this.mySuppressStringIndexingInTokens;
    }

    public void setSuppressStringIndexingInTokens(boolean theSuppressStringIndexingInTokens) {
        this.mySuppressStringIndexingInTokens = theSuppressStringIndexingInTokens;
    }

    public IPrimitiveType<Date> getPeriodIndexStartOfTime() {
        return this.myPeriodIndexStartOfTime;
    }

    public void setPeriodIndexStartOfTime(IPrimitiveType<Date> thePeriodIndexStartOfTime) {
        Validate.notNull(thePeriodIndexStartOfTime, (String)"thePeriodIndexStartOfTime must not be null", (Object[])new Object[0]);
        this.myPeriodIndexStartOfTime = thePeriodIndexStartOfTime;
    }

    public IPrimitiveType<Date> getPeriodIndexEndOfTime() {
        return this.myPeriodIndexEndOfTime;
    }

    public void setPeriodIndexEndOfTime(IPrimitiveType<Date> thePeriodIndexEndOfTime) {
        Validate.notNull(thePeriodIndexEndOfTime, (String)"thePeriodIndexEndOfTime must not be null", (Object[])new Object[0]);
        this.myPeriodIndexEndOfTime = thePeriodIndexEndOfTime;
    }

    public NormalizedQuantitySearchLevel getNormalizedQuantitySearchLevel() {
        return this.myNormalizedQuantitySearchLevel;
    }

    public void setNormalizedQuantitySearchLevel(NormalizedQuantitySearchLevel theNormalizedQuantitySearchLevel) {
        this.myNormalizedQuantitySearchLevel = theNormalizedQuantitySearchLevel;
    }

    public Set<String> getAutoVersionReferenceAtPaths() {
        return this.myAutoVersionReferenceAtPaths;
    }

    public void setAutoVersionReferenceAtPaths(String ... thePaths) {
        Set<String> paths = Collections.emptySet();
        if (thePaths != null) {
            paths = new HashSet<String>(Arrays.asList(thePaths));
        }
        this.setAutoVersionReferenceAtPaths(paths);
    }

    public void setAutoVersionReferenceAtPaths(Set<String> thePaths) {
        Set paths = (Set)ObjectUtils.defaultIfNull(thePaths, Collections.emptySet());
        HashMap<String, Set<String>> byType = new HashMap<String, Set<String>>();
        for (String nextPath : paths) {
            int doxIdx = nextPath.indexOf(46);
            Validate.isTrue((doxIdx > 0 ? 1 : 0) != 0, (String)"Invalid path for auto-version reference at path: %s", (Object[])new Object[]{nextPath});
            String type = nextPath.substring(0, doxIdx);
            byType.computeIfAbsent(type, t -> new HashSet()).add(nextPath);
        }
        this.myAutoVersionReferenceAtPaths = paths;
        this.myTypeToAutoVersionReferenceAtPaths = byType;
    }

    public Set<String> getAutoVersionReferenceAtPathsByResourceType(String theResourceType) {
        Validate.notEmpty((CharSequence)theResourceType, (String)"theResourceType must not be null or empty", (Object[])new Object[0]);
        Set retVal = this.myTypeToAutoVersionReferenceAtPaths.get(theResourceType);
        retVal = (Set)ObjectUtils.defaultIfNull(retVal, Collections.emptySet());
        return retVal;
    }

    public boolean isRespectVersionsForSearchIncludes() {
        return this.myRespectVersionsForSearchIncludes;
    }

    public void setRespectVersionsForSearchIncludes(boolean theRespectVersionsForSearchIncludes) {
        this.myRespectVersionsForSearchIncludes = theRespectVersionsForSearchIncludes;
    }

    public boolean isIndexOnUpliftedRefchains() {
        return this.myIndexOnUpliftedRefchains;
    }

    public void setIndexOnUpliftedRefchains(boolean theIndexOnUpliftedRefchains) {
        this.myIndexOnUpliftedRefchains = theIndexOnUpliftedRefchains;
    }

    public boolean isIndexOnContainedResources() {
        return this.myIndexOnContainedResources;
    }

    public void setIndexOnContainedResources(boolean theIndexOnContainedResources) {
        this.myIndexOnContainedResources = theIndexOnContainedResources;
    }

    public boolean isIndexOnContainedResourcesRecursively() {
        return this.myIndexOnContainedResourcesRecursively;
    }

    public void setIndexOnContainedResourcesRecursively(boolean theIndexOnContainedResourcesRecursively) {
        this.myIndexOnContainedResourcesRecursively = theIndexOnContainedResourcesRecursively;
    }

    public boolean isAutoSupportDefaultSearchParams() {
        return this.myAutoSupportDefaultSearchParams;
    }

    public void setAutoSupportDefaultSearchParams(boolean theAutoSupportDefaultSearchParams) {
        this.myAutoSupportDefaultSearchParams = theAutoSupportDefaultSearchParams;
    }

    public boolean isLanguageSearchParameterEnabled() {
        return this.myLanguageSearchParameterEnabled;
    }

    public void setLanguageSearchParameterEnabled(boolean theLanguageSearchParameterEnabled) {
        this.myLanguageSearchParameterEnabled = theLanguageSearchParameterEnabled;
    }

    public boolean isValidateResourceStatusForPackageUpload() {
        return this.myValidateResourceStatusForPackageUpload;
    }

    public void setValidateResourceStatusForPackageUpload(boolean theValidateResourceStatusForPackageUpload) {
        this.myValidateResourceStatusForPackageUpload = theValidateResourceStatusForPackageUpload;
    }

    private static void validateTreatBaseUrlsAsLocal(String theUrl) {
        Validate.notBlank((CharSequence)theUrl, (String)"Base URL must not be null or empty", (Object[])new Object[0]);
        int starIdx = theUrl.indexOf(42);
        if (starIdx != -1 && starIdx != theUrl.length() - 1) {
            throw new IllegalArgumentException(Msg.code((int)1525) + "Base URL wildcard character (*) can only appear at the end of the string: " + theUrl);
        }
    }

    public static enum TagStorageModeEnum {
        VERSIONED,
        NON_VERSIONED,
        INLINE;

    }

    public static enum IndexEnabledEnum {
        ENABLED,
        DISABLED;

    }
}

