/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;

@Entity
@Table(name="HFJ_RESOURCE_TYPE", uniqueConstraints={@UniqueConstraint(name="IDX_RES_TYPE_NAME", columnNames={"RES_TYPE"})})
public class ResourceTypeEntity {
    public static final String IDX_RES_TYPE_NAME = "IDX_RES_TYPE_NAME";
    @Id
    @SequenceGenerator(name="SEQ_RESOURCE_TYPE", sequenceName="SEQ_RESOURCE_TYPE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESOURCE_TYPE")
    @Column(name="RES_TYPE_ID")
    private Short myResourceTypeId;
    @FullTextField
    @Column(name="RES_TYPE", nullable=false, length=100)
    private String myResourceType;

    public Short getResourceTypeId() {
        return this.myResourceTypeId;
    }

    public void setResourceTypeId(Short myResourceTypeId) {
        this.myResourceTypeId = myResourceTypeId;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String myResourceType) {
        this.myResourceType = myResourceType;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceTypeEntity that = (ResourceTypeEntity)o;
        return Objects.equals(this.myResourceTypeId, that.myResourceTypeId) && Objects.equals(this.myResourceType, that.myResourceType);
    }

    public int hashCode() {
        return Objects.hash(this.myResourceTypeId, this.myResourceType);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceTypeEntity[");
        b.append("resourceTypeId=").append(this.myResourceTypeId);
        b.append(", resourceType=").append(this.myResourceType);
        b.append("]");
        return b.toString();
    }
}

