/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.dialect.HapiSequenceStyleGenerator;
import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.IdAndPartitionId;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTypeEntity;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import jakarta.persistence.Column;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="HFJ_RES_TAG", indexes={@Index(name="IDX_RES_TAG_RES_TAG", columnList="RES_ID, TAG_ID, PARTITION_ID"), @Index(name="IDX_RES_TAG_TAG_RES", columnList="TAG_ID, RES_ID, PARTITION_ID")}, uniqueConstraints={@UniqueConstraint(name="IDX_RESTAG_TAGID", columnNames={"PARTITION_ID", "RES_ID", "TAG_ID"})})
@IdClass(value=IdAndPartitionId.class)
public class ResourceTag
extends BaseTag {
    private static final long serialVersionUID = 1L;
    @GenericGenerator(name="SEQ_RESTAG_ID", type=HapiSequenceStyleGenerator.class)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESTAG_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="RES_ID", referencedColumnName="RES_ID", insertable=false, updatable=false, nullable=true), @JoinColumn(name="PARTITION_ID", referencedColumnName="PARTITION_ID", insertable=false, updatable=false, nullable=true)}, foreignKey=@ForeignKey(name="FK_RESTAG_RESOURCE"))
    private ResourceTable myResource;
    @Column(name="RES_TYPE", length=40, nullable=false)
    private String myResourceType;
    @Column(name="RES_ID", updatable=false, nullable=true)
    private Long myResourceId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="RES_TYPE_ID", referencedColumnName="RES_TYPE_ID", foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT), insertable=false, updatable=false, nullable=true)
    private ResourceTypeEntity myResourceTypeEntity;
    @Column(name="RES_TYPE_ID", nullable=true)
    private Short myResourceTypeId;

    public ResourceTag() {
    }

    public ResourceTag(ResourceTable theResourceTable, TagDefinition theTag, PartitionablePartitionId theRequestPartitionId) {
        this.setTag(theTag);
        this.setResource(theResourceTable);
        this.setResourceId(theResourceTable.getId().getId());
        this.setResourceType(theResourceTable.getResourceType());
        this.setResourceTypeId(theResourceTable.getResourceTypeId());
        this.setPartitionId(theRequestPartitionId);
    }

    public JpaPid getResourceId() {
        return JpaPid.fromId(this.myResourceId, this.myPartitionIdValue);
    }

    public void setResourceId(Long theResourceId) {
        this.myResourceId = theResourceId;
    }

    public ResourceTable getResource() {
        return this.myResource;
    }

    public void setResource(ResourceTable theResource) {
        this.myResource = theResource;
        this.myResourceId = theResource.getId().getId();
        this.myPartitionIdValue = theResource.getPartitionId().getPartitionId();
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public Short getResourceTypeId() {
        return this.myResourceTypeId;
    }

    public void setResourceTypeId(Short theResourceTypeId) {
        this.myResourceTypeId = theResourceTypeId;
    }

    public ResourceTypeEntity getResourceTypeEntity() {
        return this.myResourceTypeEntity;
    }

    @PrePersist
    public void prePersist() {
        this.myResourceId = this.myResource.getId().getId();
        this.myPartitionIdValue = this.myResource.getId().getPartitionId();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTag)) {
            return false;
        }
        ResourceTag other = (ResourceTag)obj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getResourceId(), (Object)other.getResourceId());
        b.append((Object)this.getTag(), (Object)other.getTag());
        return b.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getResourceId());
        b.append((Object)this.getTag());
        return b.toHashCode();
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        if (this.getPartitionId().getPartitionId() != null) {
            b.append("partition", (Object)this.getPartitionId().getPartitionId());
        }
        b.append("resId", (Object)this.getResourceId());
        b.append("resTypeId", (Object)this.getResourceTypeId());
        b.append("tag", (Object)this.getTagId());
        return b.build();
    }
}

