/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.dao.JpaPidIdentifierBridge;
import ca.uhn.fhir.jpa.model.dao.JpaPidValueBridge;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.EntityIndexStatusEnum;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryProvenanceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboStringUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboTokenNonUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamCoords;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamNumber;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantityNormalized;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.ResourceTypeEntity;
import ca.uhn.fhir.jpa.model.entity.SearchParamPresentEntity;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.jpa.model.search.ExtendedHSearchIndexData;
import ca.uhn.fhir.jpa.model.search.ResourceTableRoutingBinder;
import ca.uhn.fhir.jpa.model.search.SearchParamTextPropertyBinder;
import ca.uhn.fhir.model.primitive.IdDt;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.Session;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.annotations.GeneratorType;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.IdentifierBridgeRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.PropertyBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.RoutingBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.ValueBridgeRef;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.DocumentId;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.GenericField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.Indexed;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.IndexingDependency;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ObjectPath;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.PropertyBinding;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.PropertyValue;
import org.hibernate.tuple.ValueGenerator;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.InstantType;

@Indexed(routingBinder=@RoutingBinderRef(type=ResourceTableRoutingBinder.class))
@Entity
@Table(name="HFJ_RESOURCE", uniqueConstraints={@UniqueConstraint(name="IDX_RES_TYPE_FHIR_ID", columnNames={"PARTITION_ID", "RES_TYPE", "FHIR_ID"})}, indexes={@Index(name="IDX_RES_DATE", columnList="RES_UPDATED"), @Index(name="IDX_RES_FHIR_ID", columnList="FHIR_ID"), @Index(name="IDX_RES_TYPE_DEL_UPDATED", columnList="RES_TYPE,RES_DELETED_AT,RES_UPDATED,PARTITION_ID,RES_ID"), @Index(name="IDX_RES_RESID_UPDATED", columnList="RES_ID, RES_UPDATED, PARTITION_ID")})
@NamedEntityGraph(name="Resource.noJoins")
public class ResourceTable
extends BaseHasResource<JpaPid>
implements Serializable,
IBasePersistedResource<JpaPid> {
    public static final int RESTYPE_LEN = 40;
    public static final String HFJ_RESOURCE = "HFJ_RESOURCE";
    public static final String RES_TYPE = "RES_TYPE";
    public static final String FHIR_ID = "FHIR_ID";
    private static final int MAX_LANGUAGE_LENGTH = 20;
    private static final long serialVersionUID = 1L;
    public static final int MAX_FORCED_ID_LENGTH = 100;
    public static final String IDX_RES_TYPE_FHIR_ID = "IDX_RES_TYPE_FHIR_ID";
    public static final int FHIR_ID_LENGTH = 64;
    @Transient
    @FullTextField(name="myContentText", searchable=Searchable.YES, projectable=Projectable.YES, analyzer="standardAnalyzer")
    @OptimisticLock(excluded=true)
    @IndexingDependency(derivedFrom={@ObjectPath(value={@PropertyValue(propertyName="myVersion")})})
    private String myContentText;
    @Column(name="HASH_SHA256", length=64, nullable=true)
    @OptimisticLock(excluded=true)
    private String myHashSha256;
    @Column(name="SP_HAS_LINKS", nullable=false)
    @OptimisticLock(excluded=true)
    private boolean myHasLinks;
    @EmbeddedId
    @DocumentId(identifierBridge=@IdentifierBridgeRef(type=JpaPidIdentifierBridge.class))
    @GenericField(name="myId", projectable=Projectable.YES, valueBridge=@ValueBridgeRef(type=JpaPidValueBridge.class))
    private JpaPid myPid;
    @Column(name="PARTITION_ID", nullable=true, insertable=false, updatable=false)
    private Integer myPartitionIdValue;
    @Column(name="PARTITION_DATE", nullable=true)
    private LocalDate myPartitionDateValue;
    @Column(name="SP_INDEX_STATUS", nullable=true)
    @Enumerated(value=EnumType.ORDINAL)
    @JdbcTypeCode(value=-6)
    @OptimisticLock(excluded=true)
    private EntityIndexStatusEnum myIndexStatus;
    @Column(name="RES_LANGUAGE", length=20, nullable=true)
    @OptimisticLock(excluded=true)
    private String myLanguage;
    @Transient
    @FullTextField(name="myNarrativeText", searchable=Searchable.YES, projectable=Projectable.YES, analyzer="standardAnalyzer")
    @OptimisticLock(excluded=true)
    @IndexingDependency(derivedFrom={@ObjectPath(value={@PropertyValue(propertyName="myVersion")})})
    private String myNarrativeText;
    @Transient
    @IndexingDependency(derivedFrom={@ObjectPath(value={@PropertyValue(propertyName="myVersion")})})
    @PropertyBinding(binder=@PropertyBinderRef(type=SearchParamTextPropertyBinder.class))
    private ExtendedHSearchIndexData myLuceneIndexData;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamCoords> myParamsCoords;
    @Column(name="SP_COORDS_PRESENT", nullable=false)
    @OptimisticLock(excluded=true)
    private boolean myParamsCoordsPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamDate> myParamsDate;
    @Column(name="SP_DATE_PRESENT", nullable=false)
    @OptimisticLock(excluded=true)
    private boolean myParamsDatePopulated;
    @OptimisticLock(excluded=true)
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    private Collection<ResourceIndexedSearchParamNumber> myParamsNumber;
    @Column(name="SP_NUMBER_PRESENT", nullable=false)
    @OptimisticLock(excluded=true)
    private boolean myParamsNumberPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamQuantity> myParamsQuantity;
    @Column(name="SP_QUANTITY_PRESENT", nullable=false)
    @OptimisticLock(excluded=true)
    private boolean myParamsQuantityPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamQuantityNormalized> myParamsQuantityNormalized;
    @Column(name="SP_QUANTITY_NRML_PRESENT", nullable=false)
    @OptimisticLock(excluded=true)
    private Boolean myParamsQuantityNormalizedPopulated = Boolean.FALSE;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamString> myParamsString;
    @Column(name="SP_STRING_PRESENT", nullable=false)
    @OptimisticLock(excluded=true)
    private boolean myParamsStringPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamToken> myParamsToken;
    @Column(name="SP_TOKEN_PRESENT", nullable=false)
    @OptimisticLock(excluded=true)
    private boolean myParamsTokenPopulated;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedSearchParamUri> myParamsUri;
    @Column(name="SP_URI_PRESENT", nullable=false)
    @OptimisticLock(excluded=true)
    private boolean myParamsUriPopulated;
    @OptimisticLock(excluded=true)
    @Column(name="SP_CMPSTR_UNIQ_PRESENT")
    private Boolean myParamsComboStringUniquePresent = false;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedComboStringUnique> myParamsComboStringUnique;
    @OptimisticLock(excluded=true)
    @Column(name="SP_CMPTOKS_PRESENT")
    private Boolean myParamsComboTokensNonUniquePresent = false;
    @OneToMany(mappedBy="myResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceIndexedComboTokenNonUnique> myParamsComboTokensNonUnique;
    @OneToMany(mappedBy="mySourceResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceLink> myResourceLinks;
    @FullTextField
    @Transient
    @IndexingDependency(derivedFrom={@ObjectPath(value={@PropertyValue(propertyName="myResourceLinks")})})
    private String myResourceLinksField;
    @OneToMany(mappedBy="myTargetResource", cascade={}, fetch=FetchType.LAZY, orphanRemoval=false)
    @OptimisticLock(excluded=true)
    private Collection<ResourceLink> myResourceLinksAsTarget;
    @Column(name="RES_TYPE", length=40, nullable=false)
    @FullTextField
    @OptimisticLock(excluded=true)
    private String myResourceType;
    @OneToMany(mappedBy="myResource", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @OptimisticLock(excluded=true)
    private Collection<SearchParamPresentEntity> mySearchParamPresents;
    @OneToMany(mappedBy="myResource", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @OptimisticLock(excluded=true)
    private Set<ResourceTag> myTags;
    @Transient
    private transient boolean myUnchangedInCurrentOperation;
    @Column(name="FHIR_ID", length=64, updatable=false)
    @GeneratorType(when=GenerationTime.INSERT, type=FhirIdGenerator.class)
    @OptimisticLock(excluded=true)
    private String myFhirId;
    @OptimisticLock(excluded=true)
    @Column(name="SEARCH_URL_PRESENT", nullable=true)
    private Boolean mySearchUrlPresent = false;
    @Version
    @Column(name="RES_VER", nullable=false)
    private long myVersion;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="RES_TYPE_ID", referencedColumnName="RES_TYPE_ID", foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT), insertable=false, updatable=false, nullable=true)
    private ResourceTypeEntity myResourceTypeEntity;
    @Column(name="RES_TYPE_ID", nullable=true)
    private Short myResourceTypeId;
    @OneToMany(mappedBy="myResourceTable", fetch=FetchType.LAZY)
    private Collection<ResourceHistoryProvenanceEntity> myProvenance;
    @Transient
    private transient ResourceHistoryTable myCurrentVersionEntity;
    @Transient
    private transient boolean myVersionUpdatedInCurrentTransaction;
    @Transient
    private volatile String myCreatedByMatchUrl;
    @Transient
    private volatile String myUpdatedByMatchUrl;

    public void markVersionUpdatedInCurrentTransaction() {
        if (!this.myVersionUpdatedInCurrentTransaction) {
            ++this.myVersion;
            this.myVersionUpdatedInCurrentTransaction = true;
        }
    }

    @PostPersist
    public void postPersist() {
        this.myVersionUpdatedInCurrentTransaction = false;
    }

    @Override
    public ResourceTag addTag(TagDefinition theTag) {
        for (ResourceTag next : this.getTags()) {
            if (!next.getTag().equals(theTag)) continue;
            return next;
        }
        ResourceTag tag = new ResourceTag(this, theTag, this.getPartitionId());
        this.getTags().add(tag);
        return tag;
    }

    public String getHashSha256() {
        return this.myHashSha256;
    }

    public void setHashSha256(String theHashSha256) {
        this.myHashSha256 = theHashSha256;
    }

    @Override
    @Nonnull
    public JpaPid getId() {
        if (this.myPid == null) {
            this.myPid = new JpaPid();
        }
        this.myPid.setVersion(this.myVersion);
        this.myPid.setPartitionIdIfNotAlreadySet(this.myPartitionIdValue);
        this.myPid.setResourceType(this.myResourceType);
        return this.myPid;
    }

    public void setId(JpaPid thePid) {
        this.myPid = thePid;
    }

    @VisibleForTesting
    public void setIdForUnitTest(Long theId) {
        this.setId(JpaPid.fromId(theId));
    }

    public EntityIndexStatusEnum getIndexStatus() {
        return this.myIndexStatus;
    }

    public void setIndexStatus(EntityIndexStatusEnum theIndexStatus) {
        this.myIndexStatus = theIndexStatus;
    }

    public Collection<ResourceIndexedComboStringUnique> getParamsComboStringUnique() {
        if (this.myParamsComboStringUnique == null) {
            this.myParamsComboStringUnique = new ArrayList<ResourceIndexedComboStringUnique>();
        }
        return this.myParamsComboStringUnique;
    }

    public Collection<ResourceIndexedComboTokenNonUnique> getmyParamsComboTokensNonUnique() {
        if (this.myParamsComboTokensNonUnique == null) {
            this.myParamsComboTokensNonUnique = new ArrayList<ResourceIndexedComboTokenNonUnique>();
        }
        return this.myParamsComboTokensNonUnique;
    }

    public Collection<ResourceIndexedSearchParamCoords> getParamsCoords() {
        if (this.myParamsCoords == null) {
            this.myParamsCoords = new ArrayList<ResourceIndexedSearchParamCoords>();
        }
        return this.myParamsCoords;
    }

    public void setParamsCoords(Collection<ResourceIndexedSearchParamCoords> theParamsCoords) {
        if (!this.isParamsTokenPopulated() && theParamsCoords.isEmpty()) {
            return;
        }
        this.getParamsCoords().clear();
        this.getParamsCoords().addAll(theParamsCoords);
    }

    public Collection<ResourceIndexedSearchParamDate> getParamsDate() {
        if (this.myParamsDate == null) {
            this.myParamsDate = new ArrayList<ResourceIndexedSearchParamDate>();
        }
        return this.myParamsDate;
    }

    public void setParamsDate(Collection<ResourceIndexedSearchParamDate> theParamsDate) {
        if (!this.isParamsDatePopulated() && theParamsDate.isEmpty()) {
            return;
        }
        this.getParamsDate().clear();
        this.getParamsDate().addAll(theParamsDate);
    }

    public Collection<ResourceIndexedSearchParamNumber> getParamsNumber() {
        if (this.myParamsNumber == null) {
            this.myParamsNumber = new ArrayList<ResourceIndexedSearchParamNumber>();
        }
        return this.myParamsNumber;
    }

    public void setParamsNumber(Collection<ResourceIndexedSearchParamNumber> theNumberParams) {
        if (!this.isParamsNumberPopulated() && theNumberParams.isEmpty()) {
            return;
        }
        this.getParamsNumber().clear();
        this.getParamsNumber().addAll(theNumberParams);
    }

    public Collection<ResourceIndexedSearchParamQuantity> getParamsQuantity() {
        if (this.myParamsQuantity == null) {
            this.myParamsQuantity = new ArrayList<ResourceIndexedSearchParamQuantity>();
        }
        return this.myParamsQuantity;
    }

    public void setParamsQuantity(Collection<ResourceIndexedSearchParamQuantity> theQuantityParams) {
        if (!this.isParamsQuantityPopulated() && theQuantityParams.isEmpty()) {
            return;
        }
        this.getParamsQuantity().clear();
        this.getParamsQuantity().addAll(theQuantityParams);
    }

    public Collection<ResourceIndexedSearchParamQuantityNormalized> getParamsQuantityNormalized() {
        if (this.myParamsQuantityNormalized == null) {
            this.myParamsQuantityNormalized = new ArrayList<ResourceIndexedSearchParamQuantityNormalized>();
        }
        return this.myParamsQuantityNormalized;
    }

    public void setParamsQuantityNormalized(Collection<ResourceIndexedSearchParamQuantityNormalized> theQuantityNormalizedParams) {
        if (!this.isParamsQuantityNormalizedPopulated().booleanValue() && theQuantityNormalizedParams.isEmpty()) {
            return;
        }
        this.getParamsQuantityNormalized().clear();
        this.getParamsQuantityNormalized().addAll(theQuantityNormalizedParams);
    }

    public Collection<ResourceIndexedSearchParamString> getParamsString() {
        if (this.myParamsString == null) {
            this.myParamsString = new ArrayList<ResourceIndexedSearchParamString>();
        }
        return this.myParamsString;
    }

    public void setParamsString(Collection<ResourceIndexedSearchParamString> theParamsString) {
        if (!this.isParamsStringPopulated() && theParamsString.isEmpty()) {
            return;
        }
        this.getParamsString().clear();
        this.getParamsString().addAll(theParamsString);
    }

    public Collection<ResourceIndexedSearchParamToken> getParamsToken() {
        if (this.myParamsToken == null) {
            this.myParamsToken = new ArrayList<ResourceIndexedSearchParamToken>();
        }
        return this.myParamsToken;
    }

    public void setParamsToken(Collection<ResourceIndexedSearchParamToken> theParamsToken) {
        if (!this.isParamsTokenPopulated() && theParamsToken.isEmpty()) {
            return;
        }
        this.getParamsToken().clear();
        this.getParamsToken().addAll(theParamsToken);
    }

    public Collection<ResourceIndexedSearchParamUri> getParamsUri() {
        if (this.myParamsUri == null) {
            this.myParamsUri = new ArrayList<ResourceIndexedSearchParamUri>();
        }
        return this.myParamsUri;
    }

    public void setParamsUri(Collection<ResourceIndexedSearchParamUri> theParamsUri) {
        if (!this.isParamsTokenPopulated() && theParamsUri.isEmpty()) {
            return;
        }
        this.getParamsUri().clear();
        this.getParamsUri().addAll(theParamsUri);
    }

    @Override
    public JpaPid getResourceId() {
        return this.getId();
    }

    public Collection<ResourceLink> getResourceLinks() {
        if (this.myResourceLinks == null) {
            this.myResourceLinks = new ArrayList<ResourceLink>();
        }
        return this.myResourceLinks;
    }

    public void setResourceLinks(Collection<ResourceLink> theLinks) {
        if (!this.isHasLinks() && theLinks.isEmpty()) {
            return;
        }
        this.getResourceLinks().clear();
        this.getResourceLinks().addAll(theLinks);
    }

    @Override
    public String getResourceType() {
        return this.myResourceType;
    }

    public ResourceTable setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
        return this;
    }

    @Override
    public Short getResourceTypeId() {
        return this.myResourceTypeId;
    }

    public void setResourceTypeId(Short theResourceTypeId) {
        this.myResourceTypeId = theResourceTypeId;
    }

    public ResourceTypeEntity getMyResourceTypeEntity() {
        return this.myResourceTypeEntity;
    }

    @Override
    public Collection<ResourceTag> getTags() {
        if (this.myTags == null) {
            this.myTags = new HashSet<ResourceTag>();
        }
        return this.myTags;
    }

    @Override
    public long getVersion() {
        return this.myVersion;
    }

    @Override
    @Nonnull
    public PartitionablePartitionId getPartitionId() {
        PartitionablePartitionId retVal = this.getId().getPartitionablePartitionId();
        if (this.myPartitionIdValue != null) {
            retVal.setPartitionId(this.myPartitionIdValue);
        }
        if (this.myPartitionDateValue != null) {
            retVal.setPartitionDate(this.myPartitionDateValue);
        }
        return retVal;
    }

    public void initializeVersion() {
        assert (this.myPid == null || this.myPid.getId() == null);
        this.myVersion = 1L;
    }

    @VisibleForTesting
    public void setVersionForUnitTest(long theVersion) {
        this.myVersion = theVersion;
    }

    @Override
    public boolean isDeleted() {
        return this.getDeleted() != null;
    }

    @Override
    public void setNotDeleted() {
        this.setDeleted(null);
    }

    public boolean isHasLinks() {
        return this.myHasLinks;
    }

    public void setHasLinks(boolean theHasLinks) {
        this.myHasLinks = theHasLinks;
    }

    public void clearAllParamsPopulated() {
        this.myParamsTokenPopulated = false;
        this.myParamsCoordsPopulated = false;
        this.myParamsDatePopulated = false;
        this.myParamsNumberPopulated = false;
        this.myParamsStringPopulated = false;
        this.myParamsQuantityPopulated = false;
        this.myParamsQuantityNormalizedPopulated = false;
        this.myParamsUriPopulated = false;
        this.myHasLinks = false;
    }

    public boolean isParamsComboStringUniquePresent() {
        if (this.myParamsComboStringUniquePresent == null) {
            return false;
        }
        return this.myParamsComboStringUniquePresent;
    }

    public void setParamsComboStringUniquePresent(boolean theParamsComboStringUniquePresent) {
        this.myParamsComboStringUniquePresent = theParamsComboStringUniquePresent;
    }

    public boolean isParamsComboTokensNonUniquePresent() {
        if (this.myParamsComboTokensNonUniquePresent == null) {
            return false;
        }
        return this.myParamsComboTokensNonUniquePresent;
    }

    public void setParamsComboTokensNonUniquePresent(boolean theParamsComboTokensNonUniquePresent) {
        this.myParamsComboTokensNonUniquePresent = theParamsComboTokensNonUniquePresent;
    }

    public boolean isParamsCoordsPopulated() {
        return this.myParamsCoordsPopulated;
    }

    public void setParamsCoordsPopulated(boolean theParamsCoordsPopulated) {
        this.myParamsCoordsPopulated = theParamsCoordsPopulated;
    }

    public boolean isParamsDatePopulated() {
        return this.myParamsDatePopulated;
    }

    public void setParamsDatePopulated(boolean theParamsDatePopulated) {
        this.myParamsDatePopulated = theParamsDatePopulated;
    }

    public boolean isParamsNumberPopulated() {
        return this.myParamsNumberPopulated;
    }

    public void setParamsNumberPopulated(boolean theParamsNumberPopulated) {
        this.myParamsNumberPopulated = theParamsNumberPopulated;
    }

    public boolean isParamsQuantityPopulated() {
        return this.myParamsQuantityPopulated;
    }

    public void setParamsQuantityPopulated(boolean theParamsQuantityPopulated) {
        this.myParamsQuantityPopulated = theParamsQuantityPopulated;
    }

    public Boolean isParamsQuantityNormalizedPopulated() {
        if (this.myParamsQuantityNormalizedPopulated == null) {
            return Boolean.FALSE;
        }
        return this.myParamsQuantityNormalizedPopulated;
    }

    public void setParamsQuantityNormalizedPopulated(Boolean theParamsQuantityNormalizedPopulated) {
        this.myParamsQuantityNormalizedPopulated = theParamsQuantityNormalizedPopulated == null ? Boolean.FALSE : theParamsQuantityNormalizedPopulated;
    }

    public boolean isParamsStringPopulated() {
        return this.myParamsStringPopulated;
    }

    public void setParamsStringPopulated(boolean theParamsStringPopulated) {
        this.myParamsStringPopulated = theParamsStringPopulated;
    }

    public boolean isParamsTokenPopulated() {
        return this.myParamsTokenPopulated;
    }

    public void setParamsTokenPopulated(boolean theParamsTokenPopulated) {
        this.myParamsTokenPopulated = theParamsTokenPopulated;
    }

    public boolean isParamsUriPopulated() {
        return this.myParamsUriPopulated;
    }

    public void setParamsUriPopulated(boolean theParamsUriPopulated) {
        this.myParamsUriPopulated = theParamsUriPopulated;
    }

    public boolean isUnchangedInCurrentOperation() {
        return this.myUnchangedInCurrentOperation;
    }

    public void setUnchangedInCurrentOperation(boolean theUnchangedInCurrentOperation) {
        this.myUnchangedInCurrentOperation = theUnchangedInCurrentOperation;
    }

    public String getContentText() {
        return this.myContentText;
    }

    public void setContentText(String theContentText) {
        this.myContentText = theContentText;
    }

    public void setNarrativeText(String theNarrativeText) {
        this.myNarrativeText = theNarrativeText;
    }

    public boolean isSearchUrlPresent() {
        return Boolean.TRUE.equals(this.mySearchUrlPresent);
    }

    public void setSearchUrlPresent(boolean theSearchUrlPresent) {
        this.mySearchUrlPresent = theSearchUrlPresent;
    }

    public ResourceHistoryTable toHistory(boolean theCreateVersionTags) {
        ResourceHistoryTable retVal = new ResourceHistoryTable();
        retVal.setResourceId(this.myPid.getId());
        retVal.setResourceType(this.myResourceType);
        retVal.setResourceTypeId(this.myResourceTypeId);
        retVal.setTransientForcedId(this.getFhirId());
        retVal.setFhirVersion(this.getFhirVersion());
        retVal.setResourceTable(this);
        retVal.setPartitionId(this.getPartitionId());
        retVal.setHasTags(this.isHasTags());
        if (this.isHasTags() && theCreateVersionTags) {
            for (ResourceTag next : this.getTags()) {
                retVal.addTag(next);
            }
        }
        if (this.getCurrentVersionEntity() != null && this.getCurrentVersionEntity().getId() != null && this.getVersion() == this.getCurrentVersionEntity().getVersion()) {
            ++this.myVersion;
        }
        this.populateHistoryEntityVersionAndDates(retVal);
        return retVal;
    }

    public void populateHistoryEntityVersionAndDates(ResourceHistoryTable theResourceHistoryTable) {
        theResourceHistoryTable.setVersion(this.getVersion());
        theResourceHistoryTable.setPublished(this.getPublishedDate());
        theResourceHistoryTable.setUpdated(this.getUpdatedDate());
        theResourceHistoryTable.setDeleted(this.getDeleted());
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("partition", (Object)this.getPartitionId().getPartitionId());
        b.append("pid", (Object)this.getId().getId());
        b.append("fhirId", (Object)this.myFhirId);
        b.append("resourceType", (Object)this.myResourceType);
        b.append("resourceTypeId", (Object)this.getResourceTypeId());
        b.append("version", this.myVersion);
        b.append("lastUpdated", (Object)this.getUpdated().getValueAsString());
        if (this.getDeleted() != null) {
            b.append("deleted", (Object)new InstantType(this.getDeleted()).getValueAsString());
        }
        return b.build();
    }

    @PrePersist
    @PreUpdate
    public void preSave() {
        this.myResourceLinksField = this.myHasLinks && this.myResourceLinks != null ? this.getResourceLinks().stream().map(ResourceLink::getTargetResourcePid).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(" ")) : null;
    }

    public ResourceHistoryTable getCurrentVersionEntity() {
        return this.myCurrentVersionEntity;
    }

    public void setCurrentVersionEntity(ResourceHistoryTable theCurrentVersionEntity) {
        this.myCurrentVersionEntity = theCurrentVersionEntity;
    }

    @Override
    public JpaPid getPersistentId() {
        return this.getId();
    }

    @Override
    public IdDt getIdDt() {
        return this.createAndPopulateIdOrReturnNull(IdDt::new);
    }

    public IIdType getIdType(FhirContext theContext) {
        return this.createAndPopulateIdOrReturnNull(() -> theContext.getVersion().newIdType());
    }

    @Nullable
    private <T extends IIdType> T createAndPopulateIdOrReturnNull(Supplier<T> theNewIdInstanceSupplier) {
        String resourceId;
        if (this.myFhirId != null && !this.myFhirId.isEmpty()) {
            resourceId = this.myFhirId;
        } else {
            Long id = this.getResourceId().getId();
            if (id == null) {
                return null;
            }
            resourceId = Long.toString(id);
        }
        IIdType retVal = (IIdType)theNewIdInstanceSupplier.get();
        retVal.setValue(this.getResourceType() + "/" + resourceId + "/_history/" + this.getVersion());
        return (T)retVal;
    }

    public String getCreatedByMatchUrl() {
        return this.myCreatedByMatchUrl;
    }

    public void setCreatedByMatchUrl(String theCreatedByMatchUrl) {
        this.myCreatedByMatchUrl = theCreatedByMatchUrl;
    }

    public String getUpdatedByMatchUrl() {
        return this.myUpdatedByMatchUrl;
    }

    public void setUpdatedByMatchUrl(String theUpdatedByMatchUrl) {
        this.myUpdatedByMatchUrl = theUpdatedByMatchUrl;
    }

    public boolean isVersionUpdatedInCurrentTransaction() {
        return this.myVersionUpdatedInCurrentTransaction;
    }

    public void setLuceneIndexData(ExtendedHSearchIndexData theLuceneIndexData) {
        this.myLuceneIndexData = theLuceneIndexData;
    }

    public Collection<SearchParamPresentEntity> getSearchParamPresents() {
        if (this.mySearchParamPresents == null) {
            this.mySearchParamPresents = new ArrayList<SearchParamPresentEntity>();
        }
        return this.mySearchParamPresents;
    }

    @Override
    public String getFhirId() {
        return this.myFhirId;
    }

    public void setFhirId(String theFhirId) {
        this.myFhirId = theFhirId;
    }

    public String asTypedFhirResourceId() {
        return this.getResourceType() + "/" + this.getFhirId();
    }

    public void setPartitionId(PartitionablePartitionId theStoragePartition) {
        if (this.myPid == null) {
            this.myPid = new JpaPid();
        }
        this.myPid.setPartitionId(theStoragePartition.getPartitionId());
        this.myPartitionIdValue = theStoragePartition.getPartitionId();
        this.myPartitionDateValue = theStoragePartition.getPartitionDate();
    }

    public void setParamsComboStringUnique(Collection<ResourceIndexedComboStringUnique> theComboStringUniques) {
        this.myParamsComboStringUnique = theComboStringUniques;
    }

    public void setParamsComboTokensNonUnique(Collection<ResourceIndexedComboTokenNonUnique> theComboTokensNonUnique) {
        this.myParamsComboTokensNonUnique = theComboTokensNonUnique;
    }

    public static final class FhirIdGenerator
    implements ValueGenerator<String> {
        public String generateValue(Session session, Object owner) {
            ResourceTable that = (ResourceTable)owner;
            return that.myFhirId != null ? that.myFhirId : that.myPid.getId().toString();
        }
    }
}

