/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.Validate;

@Entity
@Table(name="HFJ_RES_SYSTEM", uniqueConstraints={@UniqueConstraint(name="IDX_RESIDENT_SYS", columnNames={"SYSTEM_URL"})})
public class ResourceSystemEntity {
    @Column(name="PID")
    @Id
    private Long myPid;
    @Column(name="SYSTEM_URL", length=500, nullable=false)
    private String mySystem;

    public Long getPid() {
        return this.myPid;
    }

    public void setSystem(String theSystem) {
        Validate.notBlank((CharSequence)theSystem, (String)"System URL cannot be blank", (Object[])new Object[0]);
        Validate.isTrue((theSystem.length() <= 500 ? 1 : 0) != 0, (String)"System URL cannot be longer than 500 characters: %s", (Object[])new Object[]{theSystem});
        this.mySystem = theSystem;
        Hasher hasher = Hashing.murmur3_128((int)0).newHasher();
        hasher.putBytes(theSystem.getBytes(StandardCharsets.UTF_8));
        this.myPid = hasher.hash().asLong();
    }
}

