/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceSearchUrlEntityPK;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.time.LocalDate;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="HFJ_RES_SEARCH_URL", indexes={@Index(name="IDX_RESSEARCHURL_RES", columnList="RES_ID"), @Index(name="IDX_RESSEARCHURL_TIME", columnList="CREATED_TIME")})
public class ResourceSearchUrlEntity {
    public static final String RES_SEARCH_URL_COLUMN_NAME = "RES_SEARCH_URL";
    public static final String PARTITION_ID = "PARTITION_ID";
    public static final String TABLE_NAME = "HFJ_RES_SEARCH_URL";
    @EmbeddedId
    private ResourceSearchUrlEntityPK myPk;
    @Column(name="RES_ID", updatable=false, nullable=false, insertable=true)
    private Long myResourcePid;
    @Column(name="PARTITION_ID", updatable=false, nullable=false, insertable=false)
    private Integer myPartitionIdValue;
    @Column(name="PARTITION_DATE", nullable=true, insertable=true, updatable=false)
    private LocalDate myPartitionDate;
    @Column(name="CREATED_TIME", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myCreatedTime;

    public static ResourceSearchUrlEntity from(String theUrl, ResourceTable theResourceTable, boolean theSearchUrlDuplicateAcrossPartitionsEnabled) {
        return new ResourceSearchUrlEntity().setPk(ResourceSearchUrlEntityPK.from(theUrl, theResourceTable, theSearchUrlDuplicateAcrossPartitionsEnabled)).setPartitionDate(Optional.ofNullable(theResourceTable.getPartitionId()).map(PartitionablePartitionId::getPartitionDate).orElse(null)).setResourceTable(theResourceTable).setCreatedTime(new Date());
    }

    public ResourceSearchUrlEntityPK getPk() {
        return this.myPk;
    }

    public ResourceSearchUrlEntity setPk(ResourceSearchUrlEntityPK thePk) {
        this.myPk = thePk;
        return this;
    }

    public JpaPid getResourcePid() {
        return JpaPid.fromId(this.myResourcePid, this.myPartitionIdValue);
    }

    public ResourceSearchUrlEntity setResourcePid(Long theResourcePid) {
        this.myResourcePid = theResourcePid;
        return this;
    }

    public ResourceSearchUrlEntity setResourceTable(ResourceTable theResourceTable) {
        this.myResourcePid = theResourceTable.getId().getId();
        this.myPartitionIdValue = theResourceTable.getPartitionId().getPartitionId();
        return this;
    }

    public Date getCreatedTime() {
        return this.myCreatedTime;
    }

    public ResourceSearchUrlEntity setCreatedTime(Date theCreatedTime) {
        this.myCreatedTime = theCreatedTime;
        return this;
    }

    public String getSearchUrl() {
        return this.myPk.getSearchUrl();
    }

    public Integer getPartitionId() {
        return this.myPk.getPartitionId();
    }

    public LocalDate getPartitionDate() {
        return this.myPartitionDate;
    }

    public ResourceSearchUrlEntity setPartitionDate(LocalDate thePartitionDate) {
        this.myPartitionDate = thePartitionDate;
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("searchUrl", (Object)this.getPk().getSearchUrl()).append("partitionId", (Object)this.myPartitionIdValue).append("resourcePid", (Object)this.myResourcePid).toString();
    }
}

