/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Objects;

@Entity
@Table(name="HFJ_RES_IDENTIFIER_PT_UNIQ")
public class ResourceIdentifierPatientUniqueEntity {
    @EmbeddedId
    private PatientIdentifierPk myPk;
    @Column(name="FHIR_ID", length=64, nullable=false)
    private String myFhirId;

    public void setPk(PatientIdentifierPk thePk) {
        this.myPk = thePk;
    }

    public String getFhirId() {
        return this.myFhirId;
    }

    public void setFhirId(String theFhirId) {
        this.myFhirId = theFhirId;
    }

    public static class PatientIdentifierPk {
        @Column(name="IDENT_SYSTEM_PID")
        private Long mySystemPid;
        @Column(name="IDENT_VALUE", length=500)
        private String myValue;

        public PatientIdentifierPk() {
        }

        public PatientIdentifierPk(Long theSystemPid, String theValue) {
            this.mySystemPid = theSystemPid;
            this.myValue = theValue;
        }

        public boolean equals(Object theO) {
            if (!(theO instanceof PatientIdentifierPk)) {
                return false;
            }
            PatientIdentifierPk that = (PatientIdentifierPk)theO;
            return Objects.equals(this.mySystemPid, that.mySystemPid) && Objects.equals(this.myValue, that.myValue);
        }

        public int hashCode() {
            return Objects.hash(this.mySystemPid, this.myValue);
        }
    }
}

