/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.dialect.HapiSequenceStyleGenerator;
import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.IdAndPartitionId;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTypeEntity;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import jakarta.persistence.Column;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="HFJ_HISTORY_TAG", uniqueConstraints={@UniqueConstraint(name="IDX_RESHISTTAG_TAGID", columnNames={"PARTITION_ID", "RES_VER_PID", "TAG_ID"})}, indexes={@Index(name="IDX_RESHISTTAG_RESID", columnList="RES_ID")})
@IdClass(value=IdAndPartitionId.class)
public class ResourceHistoryTag
extends BaseTag
implements Serializable {
    private static final long serialVersionUID = 1L;
    @GenericGenerator(name="SEQ_HISTORYTAG_ID", type=HapiSequenceStyleGenerator.class)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_HISTORYTAG_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="RES_VER_PID", referencedColumnName="PID", nullable=false, insertable=false, updatable=false), @JoinColumn(name="PARTITION_ID", referencedColumnName="PARTITION_ID", nullable=false, insertable=false, updatable=false)}, foreignKey=@ForeignKey(name="FK_HISTORYTAG_HISTORY"))
    private ResourceHistoryTable myResourceHistory;
    @Column(name="RES_VER_PID", updatable=false, nullable=false)
    private Long myResourceHistoryPid;
    @Column(name="RES_TYPE", length=40, nullable=false)
    private String myResourceType;
    @Column(name="RES_ID", nullable=false)
    private Long myResourceId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="RES_TYPE_ID", referencedColumnName="RES_TYPE_ID", foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT), insertable=false, updatable=false, nullable=true)
    private ResourceTypeEntity myResourceTypeEntity;
    @Column(name="RES_TYPE_ID", nullable=true)
    private Short myResourceTypeId;

    public ResourceHistoryTag() {
    }

    public ResourceHistoryTag(ResourceHistoryTable theResourceHistoryTable, TagDefinition theTag, PartitionablePartitionId theRequestPartitionId) {
        this();
        this.setTag(theTag);
        this.setResource(theResourceHistoryTable);
        this.setResourceId(theResourceHistoryTable.getResourceId().getId());
        this.setResourceType(theResourceHistoryTable.getResourceType());
        this.setResourceTypeId(theResourceHistoryTable.getResourceTypeId());
        this.setPartitionId(theRequestPartitionId);
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public Long getResourceId() {
        return this.myResourceId;
    }

    public void setResourceId(Long theResourceId) {
        this.myResourceId = theResourceId;
    }

    public Short getResourceTypeId() {
        return this.myResourceTypeId;
    }

    public void setResourceTypeId(Short theResourceTypeId) {
        this.myResourceTypeId = theResourceTypeId;
    }

    public ResourceTypeEntity getResourceTypeEntity() {
        return this.myResourceTypeEntity;
    }

    public ResourceHistoryTable getResourceHistory() {
        return this.myResourceHistory;
    }

    public void setResource(ResourceHistoryTable theResourceHistory) {
        this.myResourceHistory = theResourceHistory;
        this.myResourceHistoryPid = theResourceHistory.getId().getId();
        this.myPartitionIdValue = theResourceHistory.getResourceId().getPartitionId();
    }

    @PrePersist
    public void prePersist() {
        this.myResourceHistoryPid = this.myResourceHistory.getId().getId();
        this.myPartitionIdValue = this.myResourceHistory.getResourceId().getPartitionId();
    }

    public Long getId() {
        return this.myId;
    }

    public JpaPid getResourcePid() {
        return JpaPid.fromId(this.myResourceId, this.myPartitionIdValue);
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("id", (Object)this.getId());
        if (this.getPartitionId().getPartitionId() != null) {
            b.append("partId", (Object)this.getPartitionId().getPartitionId());
        }
        b.append("versionId", (Object)this.myResourceHistoryPid);
        b.append("resId", (Object)this.getResourceId());
        b.append("resTypeId", (Object)this.getResourceTypeId());
        b.append("tag", (Object)this.getTagId());
        return b.build();
    }
}

