/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.dialect.HapiSequenceStyleGenerator;
import ca.uhn.fhir.jpa.model.entity.IdAndPartitionId;
import ca.uhn.fhir.rest.api.server.storage.IResourceVersionPersistentId;
import ca.uhn.hapi.fhir.sql.hibernatesvc.PartitionedIdProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import java.io.Serializable;
import java.util.Objects;
import org.hibernate.annotations.GenericGenerator;

@Embeddable
public class ResourceHistoryTablePk
implements IResourceVersionPersistentId,
Serializable {
    @GenericGenerator(name="SEQ_RESOURCE_HISTORY_ID", type=HapiSequenceStyleGenerator.class)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESOURCE_HISTORY_ID")
    @Column(name="PID")
    private Long myVersionId;
    @PartitionedIdProperty
    @Column(name="PARTITION_ID")
    private Integer myPartitionIdValue;

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (!(theO instanceof ResourceHistoryTablePk)) {
            return false;
        }
        ResourceHistoryTablePk that = (ResourceHistoryTablePk)theO;
        return Objects.equals(this.myVersionId, that.myVersionId) && Objects.equals(this.myPartitionIdValue, that.myPartitionIdValue);
    }

    public int hashCode() {
        return Objects.hash(this.myVersionId, this.myPartitionIdValue);
    }

    public void setPartitionIdValue(Integer thePartitionIdValue) {
        this.myPartitionIdValue = thePartitionIdValue;
    }

    public Long getId() {
        return this.myVersionId;
    }

    public Integer getPartitionId() {
        return this.myPartitionIdValue;
    }

    public IdAndPartitionId asIdAndPartitionId() {
        return new IdAndPartitionId(this.getId(), this.getPartitionId());
    }

    public String toString() {
        return this.myVersionId + "/" + this.myPartitionIdValue;
    }
}

