/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.time.LocalDate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Embeddable
public class PartitionablePartitionId
implements Cloneable {
    public static final String PARTITION_ID = "PARTITION_ID";
    static final String PARTITION_DATE = "PARTITION_DATE";
    @Column(name="PARTITION_ID", nullable=true, insertable=true, updatable=false)
    private Integer myPartitionId;
    @Column(name="PARTITION_DATE", nullable=true, insertable=true, updatable=false)
    private LocalDate myPartitionDate;

    public PartitionablePartitionId() {
    }

    public PartitionablePartitionId(@Nullable Integer thePartitionId, @Nullable LocalDate thePartitionDate) {
        this.setPartitionId(thePartitionId);
        this.setPartitionDate(thePartitionDate);
    }

    @Nullable
    public Integer getPartitionId() {
        return this.myPartitionId;
    }

    public PartitionablePartitionId setPartitionId(@Nullable Integer thePartitionId) {
        this.myPartitionId = thePartitionId;
        return this;
    }

    public boolean equals(Object theO) {
        if (!(theO instanceof PartitionablePartitionId)) {
            return false;
        }
        PartitionablePartitionId that = (PartitionablePartitionId)theO;
        return new EqualsBuilder().append((Object)this.myPartitionId, (Object)that.myPartitionId).append((Object)this.myPartitionDate, (Object)that.myPartitionDate).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.myPartitionId).append((Object)this.myPartitionDate).toHashCode();
    }

    @Nullable
    public LocalDate getPartitionDate() {
        return this.myPartitionDate;
    }

    public PartitionablePartitionId setPartitionDate(@Nullable LocalDate thePartitionDate) {
        this.myPartitionDate = thePartitionDate;
        return this;
    }

    protected PartitionablePartitionId clone() {
        return new PartitionablePartitionId().setPartitionId(this.getPartitionId()).setPartitionDate(this.getPartitionDate());
    }

    public RequestPartitionId toPartitionId() {
        return RequestPartitionId.fromPartitionId((Integer)this.getPartitionId(), (LocalDate)this.getPartitionDate());
    }

    public String toString() {
        return "PartitionablePartitionId{myPartitionId=" + this.myPartitionId + ", myPartitionDate=" + String.valueOf(this.myPartitionDate) + "}";
    }

    @Nonnull
    public static RequestPartitionId toRequestPartitionId(@Nullable PartitionablePartitionId theRequestPartitionId) {
        if (theRequestPartitionId != null) {
            return theRequestPartitionId.toPartitionId();
        }
        return RequestPartitionId.defaultPartition();
    }

    @Nonnull
    public static PartitionablePartitionId toStoragePartition(@Nonnull RequestPartitionId theRequestPartitionId, @Nonnull PartitionSettings thePartitionSettings) {
        Integer partitionId = theRequestPartitionId.getFirstPartitionIdOrNull();
        if (partitionId == null) {
            partitionId = thePartitionSettings.getDefaultPartitionId();
        }
        return new PartitionablePartitionId(partitionId, theRequestPartitionId.getPartitionDate());
    }

    public static PartitionablePartitionId with(@Nullable Integer thePartitionId, @Nullable LocalDate thePartitionDate) {
        return new PartitionablePartitionId(thePartitionId, thePartitionDate);
    }
}

