/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.util.SearchParamHash;
import ca.uhn.fhir.model.api.IQueryParameterType;
import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.GenericField;

@MappedSuperclass
public abstract class BaseResourceIndexedSearchParam
extends BaseResourceIndex {
    static final int MAX_SP_NAME = 100;
    private static final long serialVersionUID = 1L;
    @GenericField
    @Column(name="SP_MISSING", nullable=false)
    private boolean myMissing = false;
    @FullTextField
    @Column(name="SP_NAME", length=100)
    private String myParamName;
    @Transient
    private transient String myParamNameCached;
    @Column(name="RES_ID", insertable=false, updatable=false, nullable=false)
    private Long myResourcePid;
    @FullTextField
    @Column(name="RES_TYPE", length=100)
    private String myResourceType;
    @Column(name="HASH_IDENTITY", nullable=true)
    protected Long myHashIdentity;
    @GenericField
    @Column(name="SP_UPDATED", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myUpdated;
    @Transient
    private transient PartitionSettings myPartitionSettings;
    @Transient
    private transient StorageSettings myStorageSettings;

    @Override
    public abstract Long getId();

    public String getParamName() {
        if (this.myParamNameCached != null) {
            return this.myParamNameCached;
        }
        return this.myParamName;
    }

    public void setParamName(String theName) {
        if (!Strings.CS.equals(this.myParamName, theName)) {
            this.myParamName = theName;
            this.clearHashes();
        }
    }

    public void restoreParamName(String theParamName) {
        if (this.myParamName == null) {
            this.myParamName = theParamName;
        }
    }

    public void optimizeIndexStorage() {
        if (StringUtils.isNotBlank((CharSequence)this.myParamName)) {
            this.myParamNameCached = this.myParamName;
            this.myParamName = null;
        }
        this.myResourceType = null;
    }

    public boolean isIndexStorageOptimized() {
        return this.myParamName == null || this.myResourceType == null;
    }

    public abstract ResourceTable getResource();

    public abstract BaseResourceIndexedSearchParam setResource(ResourceTable var1);

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        BaseResourceIndexedSearchParam source = (BaseResourceIndexedSearchParam)theSource;
        this.myMissing = source.myMissing;
        this.myParamName = source.myParamName;
        this.myResourceType = source.myResourceType;
        this.myUpdated = source.myUpdated;
        this.myStorageSettings = source.myStorageSettings;
        this.myPartitionSettings = source.myPartitionSettings;
        this.setPartitionId(source.getPartitionId());
    }

    public Long getResourcePid() {
        return this.myResourcePid;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public void setHashIdentity(Long theHashIdentity) {
        this.myHashIdentity = theHashIdentity;
    }

    public Long getHashIdentity() {
        return this.myHashIdentity;
    }

    public Date getUpdated() {
        return this.myUpdated;
    }

    public void setUpdated(Date theUpdated) {
        this.myUpdated = theUpdated;
    }

    public boolean isMissing() {
        return this.myMissing;
    }

    public BaseResourceIndexedSearchParam setMissing(boolean theMissing) {
        this.myMissing = theMissing;
        return this;
    }

    public abstract IQueryParameterType toQueryParameterType();

    public boolean matches(IQueryParameterType theParam) {
        throw new UnsupportedOperationException(Msg.code((int)1526) + "No parameter matcher for " + String.valueOf(theParam));
    }

    public PartitionSettings getPartitionSettings() {
        return this.myPartitionSettings;
    }

    public BaseResourceIndexedSearchParam setPartitionSettings(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
        return this;
    }

    public StorageSettings getStorageSettings() {
        return this.myStorageSettings;
    }

    public BaseResourceIndexedSearchParam setStorageSettings(StorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
        return this;
    }

    public static long calculateHashIdentity(PartitionSettings thePartitionSettings, PartitionablePartitionId theRequestPartitionId, String theResourceType, String theParamName) {
        RequestPartitionId requestPartitionId = PartitionablePartitionId.toRequestPartitionId(theRequestPartitionId);
        return BaseResourceIndexedSearchParam.calculateHashIdentity(thePartitionSettings, requestPartitionId, theResourceType, theParamName);
    }

    public static long calculateHashIdentity(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName) {
        return SearchParamHash.hashSearchParam(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName);
    }

    public static long calculateHashIdentity(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, List<String> theAdditionalValues) {
        String[] values = new String[theAdditionalValues.size() + 2];
        values[0] = theResourceType;
        values[1] = theParamName;
        for (int i = 0; i < theAdditionalValues.size(); ++i) {
            values[i + 2] = theAdditionalValues.get(i);
        }
        return SearchParamHash.hashSearchParam(thePartitionSettings, theRequestPartitionId, values);
    }
}

