/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.dao;

import ca.uhn.fhir.jpa.model.dao.JpaPidFk;
import ca.uhn.fhir.jpa.model.dialect.HapiSequenceStyleGenerator;
import ca.uhn.fhir.jpa.model.entity.IdAndPartitionId;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.rest.api.server.storage.BaseResourcePersistentId;
import ca.uhn.hapi.fhir.sql.hibernatesvc.PartitionedIdProperty;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.GenericField;

@Embeddable
public class JpaPid
extends BaseResourcePersistentId<Long>
implements Comparable<JpaPid> {
    @GenericGenerator(name="SEQ_RESOURCE_ID", type=HapiSequenceStyleGenerator.class)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESOURCE_ID")
    @Column(name="RES_ID", nullable=false)
    @GenericField(projectable=Projectable.YES)
    private Long myId;
    @PartitionedIdProperty
    @Column(name="PARTITION_ID", nullable=false)
    private Integer myPartitionIdValue;
    private static final Comparator<JpaPid> COMPARATOR;

    public JpaPid() {
        super(null);
    }

    private JpaPid(Long theId) {
        super(null);
        this.myId = theId;
    }

    public JpaPid(Integer thePartitionIdValue, Long theId) {
        super(null);
        this.myId = theId;
        this.myPartitionIdValue = thePartitionIdValue;
    }

    private JpaPid(Long theId, Long theVersion) {
        super(theVersion, null);
        this.myId = theId;
    }

    public JpaPid(Integer thePartitionId, Long theId, Long theVersion) {
        super(theVersion, null);
        this.myPartitionIdValue = thePartitionId;
        this.myId = theId;
    }

    private JpaPid(Long theId, String theResourceType) {
        super(theResourceType);
        this.myId = theId;
    }

    private JpaPid(Long theId, Long theVersion, String theResourceType) {
        super(theVersion, theResourceType);
        this.myId = theId;
    }

    public PartitionablePartitionId getPartitionablePartitionId() {
        return new PartitionablePartitionId(this.myPartitionIdValue, null);
    }

    public JpaPid setPartitionablePartitionId(PartitionablePartitionId thePartitionablePartitionId) {
        this.myPartitionIdValue = thePartitionablePartitionId != null ? thePartitionablePartitionId.getPartitionId() : null;
        return this;
    }

    public JpaPid setPartitionIdIfNotAlreadySet(Integer thePartitionId) {
        if (this.myPartitionIdValue == null && thePartitionId != null) {
            this.myPartitionIdValue = thePartitionId;
        }
        return this;
    }

    public Integer getPartitionId() {
        return this.myPartitionIdValue;
    }

    public void setPartitionId(Integer thePartitionId) {
        this.myPartitionIdValue = thePartitionId;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (!(theO instanceof JpaPid)) {
            return false;
        }
        JpaPid jpaPid = (JpaPid)theO;
        return Objects.equals(this.myId, jpaPid.myId);
    }

    public int hashCode() {
        return Objects.hash(this.myId);
    }

    public Long getId() {
        return this.myId;
    }

    public void setId(Long theId) {
        this.myId = theId;
    }

    public String toString() {
        String retVal = this.myPartitionIdValue != null ? this.myPartitionIdValue + "/" + this.myId.toString() : this.myId.toString();
        return retVal;
    }

    @Override
    public int compareTo(@Nonnull JpaPid theOther) {
        return COMPARATOR.compare(this, theOther);
    }

    public JpaPidFk toFk() {
        return JpaPidFk.fromPid(this);
    }

    public static List<Long> toLongList(JpaPid[] thePids) {
        return JpaPid.toLongList(Arrays.asList(thePids));
    }

    public static List<Long> toLongList(Collection<JpaPid> thePids) {
        ArrayList<Long> retVal = new ArrayList<Long>(thePids.size());
        for (JpaPid next : thePids) {
            retVal.add(next.getId());
        }
        return retVal;
    }

    public static Set<Long> toLongSet(Collection<JpaPid> thePids) {
        HashSet<Long> retVal = new HashSet<Long>(thePids.size());
        for (JpaPid next : thePids) {
            retVal.add(next.getId());
        }
        return retVal;
    }

    public static List<JpaPid> fromLongList(Collection<Long> theResultList) {
        ArrayList<JpaPid> retVal = new ArrayList<JpaPid>(theResultList.size());
        for (Long next : theResultList) {
            retVal.add(JpaPid.fromId(next));
        }
        return retVal;
    }

    public static JpaPid fromId(Long theId) {
        return new JpaPid(theId);
    }

    public static JpaPid fromId(Long theResourceId, Integer thePartitionId) {
        return new JpaPid(thePartitionId, theResourceId);
    }

    public static JpaPid fromId(Long theResourceId, PartitionablePartitionId thePartitionId) {
        return new JpaPid(thePartitionId != null ? thePartitionId.getPartitionId() : null, theResourceId);
    }

    public static JpaPid fromIdAndVersion(Long theId, Long theVersion) {
        return new JpaPid(theId, theVersion);
    }

    public static JpaPid fromIdAndResourceType(Long theId, String theResourceType) {
        return new JpaPid(theId, theResourceType);
    }

    public static JpaPid fromIdAndVersionAndResourceType(Long theId, Long theVersion, String theResourceType) {
        return new JpaPid(theId, theVersion, theResourceType);
    }

    public static JpaPid fromId(IdAndPartitionId theId) {
        JpaPid retVal = new JpaPid(theId.getId());
        retVal.setPartitionIdIfNotAlreadySet(theId.getPartitionIdValue());
        return retVal;
    }

    static {
        Comparator<JpaPid> partitionComparator = Comparator.comparing(t -> (Integer)ObjectUtils.defaultIfNull((Object)t.myPartitionIdValue, (Object)Integer.MIN_VALUE));
        Comparator<JpaPid> idComparator = Comparator.comparing(t -> t.myId);
        COMPARATOR = ComparatorUtils.chainedComparator(List.of(partitionComparator, idComparator));
    }
}

