/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.search;

import ca.uhn.fhir.jpa.model.search.ExtendedHSearchIndexData;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaObjectField;
import org.hibernate.search.engine.backend.types.Aggregable;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFinalStep;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeOptionsStep;
import org.hibernate.search.mapper.pojo.bridge.PropertyBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.PropertyBindingContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.PropertyBinder;
import org.hibernate.search.mapper.pojo.bridge.runtime.PropertyBridgeWriteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchParamTextPropertyBinder
implements PropertyBinder,
PropertyBridge<ExtendedHSearchIndexData> {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchParamTextPropertyBinder.class);
    public static final String SEARCH_PARAM_TEXT_PREFIX = "text-";
    public static final String LOWERCASE_ASCIIFOLDING_NORMALIZER = "lowercaseAsciifoldingNormalizer";

    public void bind(PropertyBindingContext thePropertyBindingContext) {
        thePropertyBindingContext.dependencies().use("mySearchParamStrings").use("mySearchParamQuantities");
        this.defineIndexingTemplate(thePropertyBindingContext);
        thePropertyBindingContext.bridge(ExtendedHSearchIndexData.class, (PropertyBridge)this);
    }

    private void defineIndexingTemplate(PropertyBindingContext thePropertyBindingContext) {
        IndexSchemaElement indexSchemaElement = thePropertyBindingContext.indexSchemaElement();
        IndexFieldTypeFactory indexFieldTypeFactory = thePropertyBindingContext.typeFactory();
        StringIndexFieldTypeOptionsStep standardAnalyzer = (StringIndexFieldTypeOptionsStep)indexFieldTypeFactory.asString().analyzer("standardAnalyzer").projectable(Projectable.NO);
        StringIndexFieldTypeOptionsStep lowerCaseNormalizer = (StringIndexFieldTypeOptionsStep)((StringIndexFieldTypeOptionsStep)indexFieldTypeFactory.asString().normalizer(LOWERCASE_ASCIIFOLDING_NORMALIZER).sortable(Sortable.YES)).projectable(Projectable.YES);
        StringIndexFieldTypeOptionsStep exactAnalyzer = (StringIndexFieldTypeOptionsStep)indexFieldTypeFactory.asString().analyzer("exactAnalyzer").projectable(Projectable.NO);
        StringIndexFieldTypeOptionsStep normStringAnalyzer = (StringIndexFieldTypeOptionsStep)indexFieldTypeFactory.asString().analyzer("normStringAnalyzer").projectable(Projectable.NO);
        StringIndexFieldTypeOptionsStep keywordFieldType = (StringIndexFieldTypeOptionsStep)((StringIndexFieldTypeOptionsStep)((StringIndexFieldTypeOptionsStep)indexFieldTypeFactory.asString().projectable(Projectable.NO)).sortable(Sortable.YES)).aggregable(Aggregable.YES);
        StandardIndexFieldTypeOptionsStep dateTimeFieldType = ((StandardIndexFieldTypeOptionsStep)indexFieldTypeFactory.asInstant().projectable(Projectable.NO)).sortable(Sortable.YES);
        StandardIndexFieldTypeOptionsStep dateTimeOrdinalFieldType = ((StandardIndexFieldTypeOptionsStep)indexFieldTypeFactory.asInteger().projectable(Projectable.NO)).sortable(Sortable.YES);
        StandardIndexFieldTypeOptionsStep bigDecimalFieldType = ((StandardIndexFieldTypeOptionsStep)indexFieldTypeFactory.asDouble().projectable(Projectable.NO)).sortable(Sortable.YES);
        StringIndexFieldTypeOptionsStep forcedIdType = (StringIndexFieldTypeOptionsStep)((StringIndexFieldTypeOptionsStep)indexFieldTypeFactory.asString().projectable(Projectable.YES)).aggregable(Aggregable.NO);
        StringIndexFieldTypeOptionsStep stringStorageType = (StringIndexFieldTypeOptionsStep)((StringIndexFieldTypeOptionsStep)((StringIndexFieldTypeOptionsStep)indexFieldTypeFactory.asString().searchable(Searchable.NO)).projectable(Projectable.YES)).aggregable(Aggregable.NO);
        indexSchemaElement.fieldTemplate("SearchParamText", (IndexFieldTypeFinalStep)standardAnalyzer).matchingPathGlob("text-*");
        indexSchemaElement.field("myForcedId", (IndexFieldTypeFinalStep)forcedIdType).toReference();
        indexSchemaElement.field("myRawResource", (IndexFieldTypeFinalStep)stringStorageType).toReference();
        IndexSchemaObjectField spfield = indexSchemaElement.objectField("sp", ObjectStructure.FLATTENED);
        spfield.toReference();
        IndexSchemaObjectField nestedSpField = indexSchemaElement.objectField("nsp", ObjectStructure.FLATTENED);
        nestedSpField.toReference();
        String stringPathGlob = "*.string";
        spfield.objectFieldTemplate("stringIndex", ObjectStructure.FLATTENED).matchingPathGlob(stringPathGlob);
        spfield.fieldTemplate("string-norm", (IndexFieldTypeFinalStep)normStringAnalyzer).matchingPathGlob(stringPathGlob + ".norm").multiValued();
        spfield.fieldTemplate("string-exact", (IndexFieldTypeFinalStep)exactAnalyzer).matchingPathGlob(stringPathGlob + ".exact").multiValued();
        spfield.fieldTemplate("string-text", (IndexFieldTypeFinalStep)standardAnalyzer).matchingPathGlob(stringPathGlob + ".text").multiValued();
        spfield.fieldTemplate("string-lower", (IndexFieldTypeFinalStep)lowerCaseNormalizer).matchingPathGlob(stringPathGlob + ".lower").multiValued();
        nestedSpField.objectFieldTemplate("nestedStringIndex", ObjectStructure.FLATTENED).matchingPathGlob(stringPathGlob);
        nestedSpField.fieldTemplate("string-norm", (IndexFieldTypeFinalStep)normStringAnalyzer).matchingPathGlob(stringPathGlob + ".norm").multiValued();
        nestedSpField.fieldTemplate("string-text", (IndexFieldTypeFinalStep)standardAnalyzer).matchingPathGlob(stringPathGlob + ".text").multiValued();
        String tokenPathGlob = "*.token";
        spfield.objectFieldTemplate("tokenIndex", ObjectStructure.FLATTENED).matchingPathGlob(tokenPathGlob);
        spfield.fieldTemplate("token-code", (IndexFieldTypeFinalStep)keywordFieldType).matchingPathGlob(tokenPathGlob + ".code").multiValued();
        spfield.fieldTemplate("token-code-system", (IndexFieldTypeFinalStep)keywordFieldType).matchingPathGlob(tokenPathGlob + ".code-system").multiValued();
        spfield.fieldTemplate("token-system", (IndexFieldTypeFinalStep)keywordFieldType).matchingPathGlob(tokenPathGlob + ".system").multiValued();
        nestedSpField.objectFieldTemplate("nestedTokenIndex", ObjectStructure.FLATTENED).matchingPathGlob(tokenPathGlob);
        nestedSpField.fieldTemplate("token-code", (IndexFieldTypeFinalStep)keywordFieldType).matchingPathGlob(tokenPathGlob + ".code").multiValued();
        nestedSpField.fieldTemplate("token-code-system", (IndexFieldTypeFinalStep)keywordFieldType).matchingPathGlob(tokenPathGlob + ".code-system").multiValued();
        nestedSpField.fieldTemplate("token-system", (IndexFieldTypeFinalStep)keywordFieldType).matchingPathGlob(tokenPathGlob + ".system").multiValued();
        spfield.fieldTemplate("reference-value", (IndexFieldTypeFinalStep)keywordFieldType).matchingPathGlob("*.reference.value").multiValued();
        spfield.fieldTemplate("uriValueTemplate", (IndexFieldTypeFinalStep)keywordFieldType).matchingPathGlob("*.uri-value").multiValued();
        nestedSpField.fieldTemplate("uriValueTemplate", (IndexFieldTypeFinalStep)keywordFieldType).matchingPathGlob("*.uri-value").multiValued();
        spfield.fieldTemplate("numberValueTemplate", (IndexFieldTypeFinalStep)bigDecimalFieldType).matchingPathGlob("*.number-value");
        nestedSpField.fieldTemplate("numberValueTemplate", (IndexFieldTypeFinalStep)bigDecimalFieldType).matchingPathGlob("*.number-value");
        String quantityPathGlob = "*.quantity";
        nestedSpField.objectFieldTemplate("quantityTemplate", ObjectStructure.FLATTENED).matchingPathGlob(quantityPathGlob);
        nestedSpField.fieldTemplate("system", (IndexFieldTypeFinalStep)keywordFieldType).matchingPathGlob(quantityPathGlob + ".system");
        nestedSpField.fieldTemplate("code", (IndexFieldTypeFinalStep)keywordFieldType).matchingPathGlob(quantityPathGlob + ".code");
        nestedSpField.fieldTemplate("value", (IndexFieldTypeFinalStep)bigDecimalFieldType).matchingPathGlob(quantityPathGlob + ".value");
        nestedSpField.fieldTemplate("code-norm", (IndexFieldTypeFinalStep)keywordFieldType).matchingPathGlob(quantityPathGlob + ".code-norm");
        nestedSpField.fieldTemplate("value-norm", (IndexFieldTypeFinalStep)bigDecimalFieldType).matchingPathGlob(quantityPathGlob + ".value-norm");
        String dateTimePathGlob = "*.dt";
        spfield.objectFieldTemplate("datetimeIndex", ObjectStructure.FLATTENED).matchingPathGlob(dateTimePathGlob);
        spfield.fieldTemplate("datetime-lower-ordinal", (IndexFieldTypeFinalStep)dateTimeOrdinalFieldType).matchingPathGlob(dateTimePathGlob + ".lower-ord").multiValued();
        spfield.fieldTemplate("datetime-lower-value", (IndexFieldTypeFinalStep)dateTimeFieldType).matchingPathGlob(dateTimePathGlob + ".lower").multiValued();
        spfield.fieldTemplate("datetime-upper-ordinal", (IndexFieldTypeFinalStep)dateTimeOrdinalFieldType).matchingPathGlob(dateTimePathGlob + ".upper-ord").multiValued();
        spfield.fieldTemplate("datetime-upper-value", (IndexFieldTypeFinalStep)dateTimeFieldType).matchingPathGlob(dateTimePathGlob + ".upper").multiValued();
        nestedSpField.objectFieldTemplate("nestedDatetimeIndex", ObjectStructure.FLATTENED).matchingPathGlob(dateTimePathGlob);
        nestedSpField.fieldTemplate("datetime-lower-ordinal", (IndexFieldTypeFinalStep)dateTimeOrdinalFieldType).matchingPathGlob(dateTimePathGlob + ".lower-ord").multiValued();
        nestedSpField.fieldTemplate("datetime-lower-value", (IndexFieldTypeFinalStep)dateTimeFieldType).matchingPathGlob(dateTimePathGlob + ".lower").multiValued();
        nestedSpField.fieldTemplate("datetime-upper-ordinal", (IndexFieldTypeFinalStep)dateTimeOrdinalFieldType).matchingPathGlob(dateTimePathGlob + ".upper-ord").multiValued();
        nestedSpField.fieldTemplate("datetime-upper-value", (IndexFieldTypeFinalStep)dateTimeFieldType).matchingPathGlob(dateTimePathGlob + ".upper").multiValued();
        spfield.objectFieldTemplate("spObject", ObjectStructure.FLATTENED).matchingPathGlob("*");
        nestedSpField.objectFieldTemplate("nestedSpSubObject", ObjectStructure.FLATTENED).matchingPathGlob("*.*").multiValued();
        nestedSpField.objectFieldTemplate("nestedSpObject", ObjectStructure.NESTED).matchingPathGlob("*").multiValued();
    }

    public void write(DocumentElement theDocument, ExtendedHSearchIndexData theIndexData, PropertyBridgeWriteContext thePropertyBridgeWriteContext) {
        if (theIndexData != null) {
            ourLog.trace("Writing index data for {}", (Object)theIndexData);
            theIndexData.writeIndexElements(theDocument);
        }
    }
}

