/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.search;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSearchElementCache {
    private static final Logger ourLog = LoggerFactory.getLogger(HSearchElementCache.class);
    private final DocumentElement myRoot;
    private final Map<String, DocumentElement> myCache = new HashMap<String, DocumentElement>();

    public HSearchElementCache(DocumentElement theRoot) {
        this.myRoot = theRoot;
    }

    public DocumentElement getObjectElement(String ... thePath) {
        return this.getObjectElement(Arrays.asList(thePath));
    }

    public DocumentElement getObjectElement(@Nonnull List<String> thePath) {
        if (thePath.size() == 0) {
            return this.myRoot;
        }
        String key = String.join((CharSequence)".", thePath);
        DocumentElement result = this.myCache.get(key);
        if (result == null) {
            DocumentElement parent = this.getObjectElement(thePath.subList(0, thePath.size() - 1));
            String lastSegment = thePath.get(thePath.size() - 1);
            assert (lastSegment.indexOf(46) == -1);
            result = parent.addObject(lastSegment);
            this.myCache.put(key, result);
        }
        ourLog.trace("getNode {}: {}", (Object)key, (Object)result);
        return result;
    }
}

