/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.dialect.HapiSequenceStyleGenerator;
import ca.uhn.fhir.jpa.model.entity.BasePartitionable;
import ca.uhn.fhir.jpa.model.entity.IdAndPartitionId;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.util.SearchParamHash;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="HFJ_RES_PARAM_PRESENT", indexes={@Index(name="IDX_RESPARMPRESENT_RESID", columnList="RES_ID"), @Index(name="IDX_RESPARMPRESENT_HASHPRES", columnList="HASH_PRESENCE")})
@IdClass(value=IdAndPartitionId.class)
public class SearchParamPresentEntity
extends BasePartitionable
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GenericGenerator(name="SEQ_RESPARMPRESENT_ID", type=HapiSequenceStyleGenerator.class)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RESPARMPRESENT_ID")
    @Column(name="PID")
    private Long myId;
    @Column(name="SP_PRESENT", nullable=false)
    private boolean myPresent;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="RES_ID", referencedColumnName="RES_ID", insertable=false, updatable=false, nullable=false), @JoinColumn(name="PARTITION_ID", referencedColumnName="PARTITION_ID", insertable=false, updatable=false, nullable=false)}, foreignKey=@ForeignKey(name="FK_RESPARMPRES_RESID"))
    private ResourceTable myResource;
    @Column(name="RES_ID", nullable=false, updatable=false)
    private Long myResourcePid;
    @Transient
    private transient String myParamName;
    @Column(name="HASH_PRESENCE")
    private Long myHashPresence;
    @Transient
    private transient PartitionSettings myPartitionSettings;

    public SearchParamPresentEntity() {
    }

    public SearchParamPresentEntity(String theParamName, boolean thePresent) {
        this.myParamName = theParamName;
        this.myPresent = thePresent;
    }

    @PrePersist
    public void calculateHashes() {
        if (this.myHashPresence == null && this.getParamName() != null) {
            String resourceType = this.getResource().getResourceType();
            String paramName = this.getParamName();
            boolean present = this.myPresent;
            this.setHashPresence(SearchParamPresentEntity.calculateHashPresence(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName, (Boolean)present));
        }
    }

    public Long getHashPresence() {
        Validate.notNull((Object)this.myHashPresence);
        return this.myHashPresence;
    }

    public void setHashPresence(Long theHashPresence) {
        this.myHashPresence = theHashPresence;
    }

    public String getParamName() {
        return this.myParamName;
    }

    public void setParamName(String theParamName) {
        this.myParamName = theParamName;
    }

    public ResourceTable getResource() {
        return this.myResource;
    }

    public void setResource(ResourceTable theResourceTable) {
        this.myResource = theResourceTable;
        this.myResourcePid = theResourceTable.getId().getId();
        this.myPartitionIdValue = theResourceTable.getPartitionId().getPartitionId();
    }

    public boolean isPresent() {
        return this.myPresent;
    }

    public void setPresent(boolean thePresent) {
        this.myPresent = thePresent;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        SearchParamPresentEntity that = (SearchParamPresentEntity)theO;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getHashPresence(), (Object)that.getHashPresence());
        return b.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder(17, 37);
        b.append((Object)this.getHashPresence());
        return b.toHashCode();
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("resPid", (Object)this.myResource.getIdDt().toUnqualifiedVersionless().getValue());
        b.append("paramName", (Object)this.myParamName);
        b.append("present", this.myPresent);
        b.append("partition", (Object)this.getPartitionId());
        return b.build();
    }

    public PartitionSettings getPartitionSettings() {
        return this.myPartitionSettings;
    }

    public void setPartitionSettings(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    public void updateValues(SearchParamPresentEntity theSource) {
        this.setPartitionId(theSource.getPartitionId());
        this.setResource(theSource.getResource());
        this.setPartitionSettings(theSource.getPartitionSettings());
        this.setHashPresence(theSource.getHashPresence());
        this.setParamName(theSource.getParamName());
        this.setPresent(theSource.isPresent());
    }

    public static long calculateHashPresence(PartitionSettings thePartitionSettings, PartitionablePartitionId theRequestPartitionId, String theResourceType, String theParamName, Boolean thePresent) {
        RequestPartitionId requestPartitionId = PartitionablePartitionId.toRequestPartitionId(theRequestPartitionId);
        return SearchParamPresentEntity.calculateHashPresence(thePartitionSettings, requestPartitionId, theResourceType, theParamName, thePresent);
    }

    public static long calculateHashPresence(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, Boolean thePresent) {
        String string = thePresent != null ? Boolean.toString(thePresent) : Boolean.toString(false);
        return SearchParamHash.hashSearchParam(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName, string);
    }
}

